/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.template;

import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.TemplateLayout;
import com.android.setupwizardlib.template.Mixin;

public class HeaderMixin
implements Mixin {
    private TemplateLayout mTemplateLayout;

    public HeaderMixin(@NonNull TemplateLayout layout2, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        this.mTemplateLayout = layout2;
        TypedArray a = layout2.getContext().obtainStyledAttributes(attrs, R.styleable.SuwHeaderMixin, defStyleAttr, 0);
        CharSequence headerText = a.getText(R.styleable.SuwHeaderMixin_suwHeaderText);
        if (headerText != null) {
            this.setText(headerText);
        }
        a.recycle();
    }

    public TextView getTextView() {
        return (TextView)this.mTemplateLayout.findManagedViewById(R.id.suw_layout_title);
    }

    public void setText(int title) {
        TextView titleView = this.getTextView();
        if (titleView != null) {
            titleView.setText(title);
        }
    }

    public void setText(CharSequence title) {
        TextView titleView = this.getTextView();
        if (titleView != null) {
            titleView.setText(title);
        }
    }

    public CharSequence getText() {
        TextView titleView = this.getTextView();
        return titleView != null ? titleView.getText() : null;
    }
}

