/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.items;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.InflateException;
import androidx.annotation.NonNull;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class SimpleInflater<T> {
    private static final String TAG = "SimpleInflater";
    private static final boolean DEBUG = false;
    protected final Resources mResources;

    protected SimpleInflater(@NonNull Resources resources) {
        this.mResources = resources;
    }

    public Resources getResources() {
        return this.mResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T inflate(int resId) {
        try (XmlResourceParser parser = this.getResources().getXml(resId);){
            T t = this.inflate((XmlPullParser)parser);
            return t;
        }
    }

    public T inflate(XmlPullParser parser) {
        T createdItem;
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        try {
            int type;
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new InflateException(parser.getPositionDescription() + ": No start tag found!");
            }
            createdItem = this.createItemFromTag(parser.getName(), attrs);
            this.rInflate(parser, createdItem, attrs);
        }
        catch (XmlPullParserException e) {
            throw new InflateException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new InflateException(parser.getPositionDescription() + ": " + e.getMessage(), (Throwable)e);
        }
        return createdItem;
    }

    protected abstract T onCreateItem(String var1, AttributeSet var2);

    private T createItemFromTag(String name, AttributeSet attrs) {
        try {
            T item = this.onCreateItem(name, attrs);
            return item;
        }
        catch (InflateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InflateException(attrs.getPositionDescription() + ": Error inflating class " + name, (Throwable)e);
        }
    }

    private void rInflate(XmlPullParser parser, T parent, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2 || this.onInterceptCreateItem(parser, parent, attrs)) continue;
            String name = parser.getName();
            T item = this.createItemFromTag(name, attrs);
            this.onAddChildItem(parent, item);
            this.rInflate(parser, item, attrs);
        }
    }

    protected boolean onInterceptCreateItem(XmlPullParser parser, T parent, AttributeSet attrs) throws XmlPullParserException {
        return false;
    }

    protected abstract void onAddChildItem(T var1, T var2);
}

