/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.items;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.TextView;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.items.SwitchItem;
import com.android.setupwizardlib.view.CheckableLinearLayout;

public class ExpandableSwitchItem
extends SwitchItem
implements CompoundButton.OnCheckedChangeListener,
View.OnClickListener {
    private CharSequence mCollapsedSummary;
    private CharSequence mExpandedSummary;
    private boolean mIsExpanded = false;

    public ExpandableSwitchItem() {
    }

    public ExpandableSwitchItem(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SuwExpandableSwitchItem);
        this.mCollapsedSummary = a.getText(R.styleable.SuwExpandableSwitchItem_suwCollapsedSummary);
        this.mExpandedSummary = a.getText(R.styleable.SuwExpandableSwitchItem_suwExpandedSummary);
        a.recycle();
    }

    @Override
    protected int getDefaultLayoutResource() {
        return R.layout.suw_items_expandable_switch;
    }

    @Override
    public CharSequence getSummary() {
        return this.mIsExpanded ? this.getExpandedSummary() : this.getCollapsedSummary();
    }

    public boolean isExpanded() {
        return this.mIsExpanded;
    }

    public void setExpanded(boolean expanded) {
        if (this.mIsExpanded == expanded) {
            return;
        }
        this.mIsExpanded = expanded;
        this.notifyItemChanged();
    }

    public CharSequence getCollapsedSummary() {
        return this.mCollapsedSummary;
    }

    public void setCollapsedSummary(CharSequence collapsedSummary) {
        this.mCollapsedSummary = collapsedSummary;
        if (!this.isExpanded()) {
            this.notifyChanged();
        }
    }

    public CharSequence getExpandedSummary() {
        return this.mExpandedSummary;
    }

    public void setExpandedSummary(CharSequence expandedSummary) {
        this.mExpandedSummary = expandedSummary;
        if (this.isExpanded()) {
            this.notifyChanged();
        }
    }

    @Override
    public void onBindView(View view) {
        super.onBindView(view);
        View content = view.findViewById(R.id.suw_items_expandable_switch_content);
        content.setOnClickListener((View.OnClickListener)this);
        if (content instanceof CheckableLinearLayout) {
            ((CheckableLinearLayout)content).setChecked(this.isExpanded());
        }
        this.tintCompoundDrawables(view);
        view.setFocusable(false);
    }

    public void onClick(View v) {
        this.setExpanded(!this.isExpanded());
    }

    private void tintCompoundDrawables(View view) {
        TypedArray a = view.getContext().obtainStyledAttributes(new int[]{16842806});
        ColorStateList tintColor = a.getColorStateList(0);
        a.recycle();
        if (tintColor != null) {
            TextView titleView = (TextView)view.findViewById(R.id.suw_items_title);
            for (Drawable drawable : titleView.getCompoundDrawables()) {
                if (drawable == null) continue;
                drawable.setColorFilter(tintColor.getDefaultColor(), PorterDuff.Mode.SRC_IN);
            }
            if (Build.VERSION.SDK_INT >= 17) {
                for (Drawable drawable : titleView.getCompoundDrawablesRelative()) {
                    if (drawable == null) continue;
                    drawable.setColorFilter(tintColor.getDefaultColor(), PorterDuff.Mode.SRC_IN);
                }
            }
        }
    }
}

