/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.template;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import com.android.setupwizardlib.DividerItemDecoration;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.TemplateLayout;
import com.android.setupwizardlib.items.ItemHierarchy;
import com.android.setupwizardlib.items.ItemInflater;
import com.android.setupwizardlib.items.RecyclerItemAdapter;
import com.android.setupwizardlib.template.Mixin;
import com.android.setupwizardlib.util.DrawableLayoutDirectionHelper;
import com.android.setupwizardlib.view.HeaderRecyclerView;

public class RecyclerMixin
implements Mixin {
    private TemplateLayout mTemplateLayout;
    @NonNull
    private final RecyclerView mRecyclerView;
    @Nullable
    private View mHeader;
    @NonNull
    private DividerItemDecoration mDividerDecoration;
    private Drawable mDefaultDivider;
    private Drawable mDivider;
    private int mDividerInsetStart;
    private int mDividerInsetEnd;

    public RecyclerMixin(@NonNull TemplateLayout layout2, @NonNull RecyclerView recyclerView) {
        this.mTemplateLayout = layout2;
        this.mDividerDecoration = new DividerItemDecoration(this.mTemplateLayout.getContext());
        this.mRecyclerView = recyclerView;
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mTemplateLayout.getContext()));
        if (recyclerView instanceof HeaderRecyclerView) {
            this.mHeader = ((HeaderRecyclerView)recyclerView).getHeader();
        }
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.mDividerDecoration);
    }

    public void parseAttributes(@Nullable AttributeSet attrs, int defStyleAttr) {
        int dividerInset;
        Context context = this.mTemplateLayout.getContext();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SuwRecyclerMixin, defStyleAttr, 0);
        int entries = a.getResourceId(R.styleable.SuwRecyclerMixin_android_entries, 0);
        if (entries != 0) {
            ItemHierarchy inflated = (ItemHierarchy)new ItemInflater(context).inflate(entries);
            RecyclerItemAdapter adapter = new RecyclerItemAdapter(inflated);
            adapter.setHasStableIds(a.getBoolean(R.styleable.SuwRecyclerMixin_suwHasStableIds, false));
            this.setAdapter(adapter);
        }
        if ((dividerInset = a.getDimensionPixelSize(R.styleable.SuwRecyclerMixin_suwDividerInset, -1)) != -1) {
            this.setDividerInset(dividerInset);
        } else {
            int dividerInsetStart = a.getDimensionPixelSize(R.styleable.SuwRecyclerMixin_suwDividerInsetStart, 0);
            int dividerInsetEnd = a.getDimensionPixelSize(R.styleable.SuwRecyclerMixin_suwDividerInsetEnd, 0);
            this.setDividerInsets(dividerInsetStart, dividerInsetEnd);
        }
        a.recycle();
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public View getHeader() {
        return this.mHeader;
    }

    public void onLayout() {
        if (this.mDivider == null) {
            this.updateDivider();
        }
    }

    public RecyclerView.Adapter<? extends RecyclerView.ViewHolder> getAdapter() {
        RecyclerView.Adapter adapter = this.mRecyclerView.getAdapter();
        if (adapter instanceof HeaderRecyclerView.HeaderAdapter) {
            return ((HeaderRecyclerView.HeaderAdapter)adapter).getWrappedAdapter();
        }
        return adapter;
    }

    public void setAdapter(RecyclerView.Adapter<? extends RecyclerView.ViewHolder> adapter) {
        this.mRecyclerView.setAdapter(adapter);
    }

    @Deprecated
    public void setDividerInset(int inset) {
        this.setDividerInsets(inset, 0);
    }

    public void setDividerInsets(int start, int end) {
        this.mDividerInsetStart = start;
        this.mDividerInsetEnd = end;
        this.updateDivider();
    }

    @Deprecated
    public int getDividerInset() {
        return this.getDividerInsetStart();
    }

    public int getDividerInsetStart() {
        return this.mDividerInsetStart;
    }

    public int getDividerInsetEnd() {
        return this.mDividerInsetEnd;
    }

    private void updateDivider() {
        boolean shouldUpdate = true;
        if (Build.VERSION.SDK_INT >= 19) {
            shouldUpdate = this.mTemplateLayout.isLayoutDirectionResolved();
        }
        if (shouldUpdate) {
            if (this.mDefaultDivider == null) {
                this.mDefaultDivider = this.mDividerDecoration.getDivider();
            }
            this.mDivider = DrawableLayoutDirectionHelper.createRelativeInsetDrawable(this.mDefaultDivider, this.mDividerInsetStart, 0, this.mDividerInsetEnd, 0, (View)this.mTemplateLayout);
            this.mDividerDecoration.setDivider(this.mDivider);
        }
    }

    public Drawable getDivider() {
        return this.mDivider;
    }

    public void setDividerItemDecoration(@NonNull DividerItemDecoration decoration) {
        this.mRecyclerView.removeItemDecoration((RecyclerView.ItemDecoration)this.mDividerDecoration);
        this.mDividerDecoration = decoration;
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.mDividerDecoration);
        this.updateDivider();
    }
}

