/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.template;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.TemplateLayout;
import com.android.setupwizardlib.items.ItemAdapter;
import com.android.setupwizardlib.items.ItemGroup;
import com.android.setupwizardlib.items.ItemInflater;
import com.android.setupwizardlib.template.Mixin;
import com.android.setupwizardlib.util.DrawableLayoutDirectionHelper;

public class ListMixin
implements Mixin {
    private TemplateLayout mTemplateLayout;
    @Nullable
    private ListView mListView;
    private Drawable mDivider;
    private Drawable mDefaultDivider;
    private int mDividerInsetStart;
    private int mDividerInsetEnd;

    public ListMixin(@NonNull TemplateLayout layout2, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        int dividerInset;
        this.mTemplateLayout = layout2;
        Context context = layout2.getContext();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SuwListMixin, defStyleAttr, 0);
        int entries = a.getResourceId(R.styleable.SuwListMixin_android_entries, 0);
        if (entries != 0) {
            ItemGroup inflated = (ItemGroup)new ItemInflater(context).inflate(entries);
            this.setAdapter((ListAdapter)new ItemAdapter(inflated));
        }
        if ((dividerInset = a.getDimensionPixelSize(R.styleable.SuwListMixin_suwDividerInset, -1)) != -1) {
            this.setDividerInset(dividerInset);
        } else {
            int dividerInsetStart = a.getDimensionPixelSize(R.styleable.SuwListMixin_suwDividerInsetStart, 0);
            int dividerInsetEnd = a.getDimensionPixelSize(R.styleable.SuwListMixin_suwDividerInsetEnd, 0);
            this.setDividerInsets(dividerInsetStart, dividerInsetEnd);
        }
        a.recycle();
    }

    public ListView getListView() {
        return this.getListViewInternal();
    }

    @Nullable
    private ListView getListViewInternal() {
        View list;
        if (this.mListView == null && (list = this.mTemplateLayout.findManagedViewById(16908298)) instanceof ListView) {
            this.mListView = (ListView)list;
        }
        return this.mListView;
    }

    public void onLayout() {
        if (this.mDivider == null) {
            this.updateDivider();
        }
    }

    public ListAdapter getAdapter() {
        ListView listView = this.getListViewInternal();
        if (listView != null) {
            ListAdapter adapter = listView.getAdapter();
            if (adapter instanceof HeaderViewListAdapter) {
                return ((HeaderViewListAdapter)adapter).getWrappedAdapter();
            }
            return adapter;
        }
        return null;
    }

    public void setAdapter(ListAdapter adapter) {
        ListView listView = this.getListViewInternal();
        if (listView != null) {
            listView.setAdapter(adapter);
        }
    }

    @Deprecated
    public void setDividerInset(int inset) {
        this.setDividerInsets(inset, 0);
    }

    public void setDividerInsets(int start, int end) {
        this.mDividerInsetStart = start;
        this.mDividerInsetEnd = end;
        this.updateDivider();
    }

    @Deprecated
    public int getDividerInset() {
        return this.getDividerInsetStart();
    }

    public int getDividerInsetStart() {
        return this.mDividerInsetStart;
    }

    public int getDividerInsetEnd() {
        return this.mDividerInsetEnd;
    }

    private void updateDivider() {
        ListView listView = this.getListViewInternal();
        if (listView == null) {
            return;
        }
        boolean shouldUpdate = true;
        if (Build.VERSION.SDK_INT >= 19) {
            shouldUpdate = this.mTemplateLayout.isLayoutDirectionResolved();
        }
        if (shouldUpdate) {
            if (this.mDefaultDivider == null) {
                this.mDefaultDivider = listView.getDivider();
            }
            this.mDivider = DrawableLayoutDirectionHelper.createRelativeInsetDrawable(this.mDefaultDivider, this.mDividerInsetStart, 0, this.mDividerInsetEnd, 0, (View)this.mTemplateLayout);
            listView.setDivider(this.mDivider);
        }
    }

    public Drawable getDivider() {
        return this.mDivider;
    }
}

