/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.util;

import android.graphics.Rect;
import android.os.Bundle;
import android.support.v4.os.BuildCompat;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.view.accessibility.AccessibilityNodeProviderCompat;
import android.support.v4.widget.ExploreByTouchHelper;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.ClickableSpan;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.TextView;
import java.util.List;

public class LinkAccessibilityHelper
extends AccessibilityDelegateCompat {
    private static final String TAG = "LinkAccessibilityHelper";
    private final TextView mView;
    private final Rect mTempRect = new Rect();
    private final ExploreByTouchHelper mExploreByTouchHelper;

    public LinkAccessibilityHelper(TextView view) {
        this.mExploreByTouchHelper = !BuildCompat.isAtLeastO() ? new ExploreByTouchHelper((View)view){

            protected int getVirtualViewAt(float x, float y) {
                return LinkAccessibilityHelper.this.getVirtualViewAt(x, y);
            }

            protected void getVisibleVirtualViews(List<Integer> virtualViewIds) {
                LinkAccessibilityHelper.this.getVisibleVirtualViews(virtualViewIds);
            }

            protected void onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
                LinkAccessibilityHelper.this.onPopulateEventForVirtualView(virtualViewId, event);
            }

            protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfoCompat infoCompat) {
                LinkAccessibilityHelper.this.onPopulateNodeForVirtualView(virtualViewId, infoCompat);
            }

            protected boolean onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
                return LinkAccessibilityHelper.this.onPerformActionForVirtualView(virtualViewId, action, arguments);
            }
        } : null;
        this.mView = view;
    }

    public void sendAccessibilityEvent(View host, int eventType) {
        if (this.mExploreByTouchHelper != null) {
            this.mExploreByTouchHelper.sendAccessibilityEvent(host, eventType);
        } else {
            super.sendAccessibilityEvent(host, eventType);
        }
    }

    public void sendAccessibilityEventUnchecked(View host, AccessibilityEvent event) {
        if (this.mExploreByTouchHelper != null) {
            this.mExploreByTouchHelper.sendAccessibilityEventUnchecked(host, event);
        } else {
            super.sendAccessibilityEventUnchecked(host, event);
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
        return this.mExploreByTouchHelper != null ? this.mExploreByTouchHelper.dispatchPopulateAccessibilityEvent(host, event) : super.dispatchPopulateAccessibilityEvent(host, event);
    }

    public void onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
        if (this.mExploreByTouchHelper != null) {
            this.mExploreByTouchHelper.onPopulateAccessibilityEvent(host, event);
        } else {
            super.onPopulateAccessibilityEvent(host, event);
        }
    }

    public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
        if (this.mExploreByTouchHelper != null) {
            this.mExploreByTouchHelper.onInitializeAccessibilityEvent(host, event);
        } else {
            super.onInitializeAccessibilityEvent(host, event);
        }
    }

    public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
        if (this.mExploreByTouchHelper != null) {
            this.mExploreByTouchHelper.onInitializeAccessibilityNodeInfo(host, info);
        } else {
            super.onInitializeAccessibilityNodeInfo(host, info);
        }
    }

    public boolean onRequestSendAccessibilityEvent(ViewGroup host, View child, AccessibilityEvent event) {
        return this.mExploreByTouchHelper != null ? this.mExploreByTouchHelper.onRequestSendAccessibilityEvent(host, child, event) : super.onRequestSendAccessibilityEvent(host, child, event);
    }

    public AccessibilityNodeProviderCompat getAccessibilityNodeProvider(View host) {
        return this.mExploreByTouchHelper != null ? this.mExploreByTouchHelper.getAccessibilityNodeProvider(host) : super.getAccessibilityNodeProvider(host);
    }

    public boolean performAccessibilityAction(View host, int action, Bundle args) {
        return this.mExploreByTouchHelper != null ? this.mExploreByTouchHelper.performAccessibilityAction(host, action, args) : super.performAccessibilityAction(host, action, args);
    }

    public final boolean dispatchHoverEvent(MotionEvent event) {
        return this.mExploreByTouchHelper != null ? this.mExploreByTouchHelper.dispatchHoverEvent(event) : false;
    }

    protected int getVirtualViewAt(float x, float y) {
        int offset;
        Spanned spannedText;
        ClickableSpan[] linkSpans;
        CharSequence text = this.mView.getText();
        if (text instanceof Spanned && (linkSpans = (ClickableSpan[])(spannedText = (Spanned)text).getSpans(offset = LinkAccessibilityHelper.getOffsetForPosition(this.mView, x, y), offset, ClickableSpan.class)).length == 1) {
            ClickableSpan linkSpan = linkSpans[0];
            return spannedText.getSpanStart((Object)linkSpan);
        }
        return Integer.MIN_VALUE;
    }

    protected void getVisibleVirtualViews(List<Integer> virtualViewIds) {
        CharSequence text = this.mView.getText();
        if (text instanceof Spanned) {
            ClickableSpan[] linkSpans;
            Spanned spannedText = (Spanned)text;
            for (ClickableSpan span : linkSpans = (ClickableSpan[])spannedText.getSpans(0, spannedText.length(), ClickableSpan.class)) {
                virtualViewIds.add(spannedText.getSpanStart((Object)span));
            }
        }
    }

    protected void onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
        ClickableSpan span = this.getSpanForOffset(virtualViewId);
        if (span != null) {
            event.setContentDescription(this.getTextForSpan(span));
        } else {
            Log.e((String)TAG, (String)("LinkSpan is null for offset: " + virtualViewId));
            event.setContentDescription(this.mView.getText());
        }
    }

    protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfoCompat info) {
        ClickableSpan span = this.getSpanForOffset(virtualViewId);
        if (span != null) {
            info.setContentDescription(this.getTextForSpan(span));
        } else {
            Log.e((String)TAG, (String)("LinkSpan is null for offset: " + virtualViewId));
            info.setContentDescription(this.mView.getText());
        }
        info.setFocusable(true);
        info.setClickable(true);
        this.getBoundsForSpan(span, this.mTempRect);
        if (this.mTempRect.isEmpty()) {
            Log.e((String)TAG, (String)("LinkSpan bounds is empty for: " + virtualViewId));
            this.mTempRect.set(0, 0, 1, 1);
        }
        info.setBoundsInParent(this.mTempRect);
        info.addAction(16);
    }

    protected boolean onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
        if (action == 16) {
            ClickableSpan span = this.getSpanForOffset(virtualViewId);
            if (span != null) {
                span.onClick((View)this.mView);
                return true;
            }
            Log.e((String)TAG, (String)("LinkSpan is null for offset: " + virtualViewId));
        }
        return false;
    }

    private ClickableSpan getSpanForOffset(int offset) {
        Spanned spannedText;
        ClickableSpan[] spans;
        CharSequence text = this.mView.getText();
        if (text instanceof Spanned && (spans = (ClickableSpan[])(spannedText = (Spanned)text).getSpans(offset, offset, ClickableSpan.class)).length == 1) {
            return spans[0];
        }
        return null;
    }

    private CharSequence getTextForSpan(ClickableSpan span) {
        CharSequence text = this.mView.getText();
        if (text instanceof Spanned) {
            Spanned spannedText = (Spanned)text;
            return spannedText.subSequence(spannedText.getSpanStart((Object)span), spannedText.getSpanEnd((Object)span));
        }
        return text;
    }

    private Rect getBoundsForSpan(ClickableSpan span, Rect outRect) {
        Layout layout2;
        CharSequence text = this.mView.getText();
        outRect.setEmpty();
        if (text instanceof Spanned && (layout2 = this.mView.getLayout()) != null) {
            Spanned spannedText = (Spanned)text;
            int spanStart = spannedText.getSpanStart((Object)span);
            int spanEnd = spannedText.getSpanEnd((Object)span);
            float xStart = layout2.getPrimaryHorizontal(spanStart);
            float xEnd = layout2.getPrimaryHorizontal(spanEnd);
            int lineStart = layout2.getLineForOffset(spanStart);
            int lineEnd = layout2.getLineForOffset(spanEnd);
            layout2.getLineBounds(lineStart, outRect);
            if (lineEnd == lineStart) {
                outRect.left = (int)Math.min(xStart, xEnd);
                outRect.right = (int)Math.max(xStart, xEnd);
            } else if (layout2.getParagraphDirection(lineStart) == -1) {
                outRect.right = (int)xStart;
            } else {
                outRect.left = (int)xStart;
            }
            outRect.offset(this.mView.getTotalPaddingLeft(), this.mView.getTotalPaddingTop());
        }
        return outRect;
    }

    private static int getOffsetForPosition(TextView view, float x, float y) {
        if (view.getLayout() == null) {
            return -1;
        }
        int line = LinkAccessibilityHelper.getLineAtCoordinate(view, y);
        return LinkAccessibilityHelper.getOffsetAtCoordinate(view, line, x);
    }

    private static float convertToLocalHorizontalCoordinate(TextView view, float x) {
        x -= (float)view.getTotalPaddingLeft();
        x = Math.max(0.0f, x);
        x = Math.min((float)(view.getWidth() - view.getTotalPaddingRight() - 1), x);
        return x += (float)view.getScrollX();
    }

    private static int getLineAtCoordinate(TextView view, float y) {
        y -= (float)view.getTotalPaddingTop();
        y = Math.max(0.0f, y);
        y = Math.min((float)(view.getHeight() - view.getTotalPaddingBottom() - 1), y);
        return view.getLayout().getLineForVertical((int)(y += (float)view.getScrollY()));
    }

    private static int getOffsetAtCoordinate(TextView view, int line, float x) {
        x = LinkAccessibilityHelper.convertToLocalHorizontalCoordinate(view, x);
        return view.getLayout().getOffsetForHorizontal(line, x);
    }
}

