/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.template;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.TemplateLayout;
import com.android.setupwizardlib.template.Mixin;

public class IconMixin
implements Mixin {
    private TemplateLayout mTemplateLayout;

    public IconMixin(TemplateLayout layout2, AttributeSet attrs, int defStyleAttr) {
        this.mTemplateLayout = layout2;
        Context context = layout2.getContext();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SuwIconMixin, defStyleAttr, 0);
        Drawable icon = a.getDrawable(R.styleable.SuwIconMixin_android_icon);
        if (icon != null) {
            this.setIcon(icon);
        }
        a.recycle();
    }

    public void setIcon(Drawable icon) {
        ImageView iconView = this.getView();
        if (iconView != null) {
            iconView.setImageDrawable(icon);
        }
    }

    public Drawable getIcon() {
        ImageView iconView = this.getView();
        return iconView != null ? iconView.getDrawable() : null;
    }

    protected ImageView getView() {
        return (ImageView)this.mTemplateLayout.findManagedViewById(R.id.suw_layout_icon);
    }
}

