/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.template;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.Button;
import android.widget.LinearLayout;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.TemplateLayout;
import com.android.setupwizardlib.template.Mixin;

public class ButtonFooterMixin
implements Mixin {
    private final Context mContext;
    @Nullable
    private final ViewStub mFooterStub;
    private LinearLayout mButtonContainer;

    public ButtonFooterMixin(TemplateLayout layout2) {
        this.mContext = layout2.getContext();
        this.mFooterStub = (ViewStub)layout2.findManagedViewById(R.id.suw_layout_footer);
    }

    public Button addButton(CharSequence text, @StyleRes int theme) {
        Button button = this.createThemedButton(this.mContext, theme);
        button.setText(text);
        return this.addButton(button);
    }

    public Button addButton(@StringRes int text, @StyleRes int theme) {
        Button button = this.createThemedButton(this.mContext, theme);
        button.setText(text);
        return this.addButton(button);
    }

    public Button addButton(Button button) {
        LinearLayout buttonContainer = this.ensureFooterInflated();
        buttonContainer.addView((View)button);
        return button;
    }

    public View addSpace() {
        LinearLayout buttonContainer = this.ensureFooterInflated();
        View space = new View(buttonContainer.getContext());
        space.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
        space.setVisibility(4);
        buttonContainer.addView(space);
        return space;
    }

    public void removeButton(Button button) {
        if (this.mButtonContainer != null) {
            this.mButtonContainer.removeView((View)button);
        }
    }

    public void removeSpace(View space) {
        if (this.mButtonContainer != null) {
            this.mButtonContainer.removeView(space);
        }
    }

    public void removeAllViews() {
        if (this.mButtonContainer != null) {
            this.mButtonContainer.removeAllViews();
        }
    }

    @NonNull
    private LinearLayout ensureFooterInflated() {
        if (this.mButtonContainer == null) {
            if (this.mFooterStub == null) {
                throw new IllegalStateException("Footer stub is not found in this template");
            }
            this.mFooterStub.setLayoutResource(R.layout.suw_glif_footer_button_bar);
            this.mButtonContainer = (LinearLayout)this.mFooterStub.inflate();
        }
        return this.mButtonContainer;
    }

    @SuppressLint(value={"InflateParams"})
    private Button createThemedButton(Context context, @StyleRes int theme) {
        LayoutInflater inflater = LayoutInflater.from((Context)new ContextThemeWrapper(context, theme));
        return (Button)inflater.inflate(R.layout.suw_button, null, false);
    }
}

