/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.items;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.support.annotation.VisibleForTesting;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.items.AbstractItem;
import com.android.setupwizardlib.items.IItem;
import com.android.setupwizardlib.items.ItemHierarchy;
import com.android.setupwizardlib.items.ItemViewHolder;

public class RecyclerItemAdapter
extends RecyclerView.Adapter<ItemViewHolder>
implements ItemHierarchy.Observer {
    private static final String TAG = "RecyclerItemAdapter";
    public static final String TAG_NO_BACKGROUND = "noBackground";
    private final ItemHierarchy mItemHierarchy;
    private OnItemSelectedListener mListener;

    public RecyclerItemAdapter(ItemHierarchy hierarchy) {
        this.mItemHierarchy = hierarchy;
        this.mItemHierarchy.registerObserver(this);
    }

    public IItem getItem(int position) {
        return this.mItemHierarchy.getItemAt(position);
    }

    public long getItemId(int position) {
        IItem mItem = this.getItem(position);
        if (mItem instanceof AbstractItem) {
            int id2 = ((AbstractItem)mItem).getId();
            return id2 > 0 ? (long)id2 : -1L;
        }
        return -1L;
    }

    public int getItemCount() {
        return this.mItemHierarchy.getCount();
    }

    public ItemViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        View view = inflater.inflate(viewType, parent, false);
        final ItemViewHolder viewHolder = new ItemViewHolder(view);
        Object viewTag = view.getTag();
        if (!TAG_NO_BACKGROUND.equals(viewTag)) {
            TypedArray typedArray = parent.getContext().obtainStyledAttributes(R.styleable.SuwRecyclerItemAdapter);
            Drawable selectableItemBackground = typedArray.getDrawable(R.styleable.SuwRecyclerItemAdapter_android_selectableItemBackground);
            if (selectableItemBackground == null) {
                selectableItemBackground = typedArray.getDrawable(R.styleable.SuwRecyclerItemAdapter_selectableItemBackground);
            }
            Drawable background = typedArray.getDrawable(R.styleable.SuwRecyclerItemAdapter_android_colorBackground);
            if (selectableItemBackground == null || background == null) {
                Log.e((String)TAG, (String)("Cannot resolve required attributes. selectableItemBackground=" + selectableItemBackground + " background=" + background));
            } else {
                Drawable[] layers = new Drawable[]{background, selectableItemBackground};
                view.setBackgroundDrawable((Drawable)new PatchedLayerDrawable(layers));
            }
            typedArray.recycle();
        }
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                IItem item = viewHolder.getItem();
                if (RecyclerItemAdapter.this.mListener != null && item != null && item.isEnabled()) {
                    RecyclerItemAdapter.this.mListener.onItemSelected(item);
                }
            }
        });
        return viewHolder;
    }

    public void onBindViewHolder(ItemViewHolder holder, int position) {
        IItem item = this.getItem(position);
        item.onBindView(holder.itemView);
        holder.setEnabled(item.isEnabled());
        holder.setItem(item);
    }

    public int getItemViewType(int position) {
        IItem item = this.getItem(position);
        return item.getLayoutResource();
    }

    @Override
    public void onChanged(ItemHierarchy hierarchy) {
        this.notifyDataSetChanged();
    }

    @Override
    public void onItemRangeChanged(ItemHierarchy itemHierarchy, int positionStart, int itemCount) {
        this.notifyItemRangeChanged(positionStart, itemCount);
    }

    @Override
    public void onItemRangeInserted(ItemHierarchy itemHierarchy, int positionStart, int itemCount) {
        this.notifyItemRangeInserted(positionStart, itemCount);
    }

    @Override
    public void onItemRangeMoved(ItemHierarchy itemHierarchy, int fromPosition, int toPosition, int itemCount) {
        if (itemCount == 1) {
            this.notifyItemMoved(fromPosition, toPosition);
        } else {
            Log.i((String)TAG, (String)"onItemRangeMoved with more than one item");
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void onItemRangeRemoved(ItemHierarchy itemHierarchy, int positionStart, int itemCount) {
        this.notifyItemRangeRemoved(positionStart, itemCount);
    }

    public ItemHierarchy findItemById(int id2) {
        return this.mItemHierarchy.findItemById(id2);
    }

    public ItemHierarchy getRootItemHierarchy() {
        return this.mItemHierarchy;
    }

    public void setOnItemSelectedListener(OnItemSelectedListener listener) {
        this.mListener = listener;
    }

    @VisibleForTesting
    static class PatchedLayerDrawable
    extends LayerDrawable {
        PatchedLayerDrawable(Drawable[] layers) {
            super(layers);
        }

        public boolean getPadding(Rect padding) {
            boolean superHasPadding = super.getPadding(padding);
            return superHasPadding && (padding.left != 0 || padding.top != 0 || padding.right != 0 || padding.bottom != 0);
        }
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(IItem var1);
    }
}

