/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.items;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.items.AbstractItem;

public class Item
extends AbstractItem {
    private boolean mEnabled = true;
    private Drawable mIcon;
    private int mLayoutRes;
    private CharSequence mSummary;
    private CharSequence mTitle;
    private boolean mVisible = true;

    public Item() {
        this.mLayoutRes = this.getDefaultLayoutResource();
    }

    public Item(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SuwItem);
        this.mEnabled = a.getBoolean(R.styleable.SuwItem_android_enabled, true);
        this.mIcon = a.getDrawable(R.styleable.SuwItem_android_icon);
        this.mTitle = a.getText(R.styleable.SuwItem_android_title);
        this.mSummary = a.getText(R.styleable.SuwItem_android_summary);
        this.mLayoutRes = a.getResourceId(R.styleable.SuwItem_android_layout, this.getDefaultLayoutResource());
        this.mVisible = a.getBoolean(R.styleable.SuwItem_android_visible, true);
        a.recycle();
    }

    protected int getDefaultLayoutResource() {
        return R.layout.suw_items_default;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
        this.notifyItemChanged();
    }

    @Override
    public int getCount() {
        return this.isVisible() ? 1 : 0;
    }

    @Override
    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setIcon(Drawable icon) {
        this.mIcon = icon;
        this.notifyItemChanged();
    }

    public Drawable getIcon() {
        return this.mIcon;
    }

    public void setLayoutResource(int layoutResource) {
        this.mLayoutRes = layoutResource;
        this.notifyItemChanged();
    }

    @Override
    public int getLayoutResource() {
        return this.mLayoutRes;
    }

    public void setSummary(CharSequence summary) {
        this.mSummary = summary;
        this.notifyItemChanged();
    }

    public CharSequence getSummary() {
        return this.mSummary;
    }

    public void setTitle(CharSequence title) {
        this.mTitle = title;
        this.notifyItemChanged();
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public void setVisible(boolean visible) {
        if (this.mVisible == visible) {
            return;
        }
        this.mVisible = visible;
        if (!visible) {
            this.notifyItemRangeRemoved(0, 1);
        } else {
            this.notifyItemRangeInserted(0, 1);
        }
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    @Override
    public int getViewId() {
        return this.getId();
    }

    @Override
    public void onBindView(View view) {
        TextView label = (TextView)view.findViewById(R.id.suw_items_title);
        label.setText(this.getTitle());
        TextView summaryView = (TextView)view.findViewById(R.id.suw_items_summary);
        CharSequence summary = this.getSummary();
        if (summary != null && summary.length() > 0) {
            summaryView.setText(summary);
            summaryView.setVisibility(0);
        } else {
            summaryView.setVisibility(8);
        }
        View iconContainer = view.findViewById(R.id.suw_items_icon_container);
        Drawable icon = this.getIcon();
        if (icon != null) {
            ImageView iconView = (ImageView)view.findViewById(R.id.suw_items_icon);
            iconView.setImageDrawable(null);
            iconView.setImageState(icon.getState(), false);
            iconView.setImageLevel(icon.getLevel());
            iconView.setImageDrawable(icon);
            iconContainer.setVisibility(0);
        } else {
            iconContainer.setVisibility(8);
        }
        view.setId(this.getViewId());
    }
}

