/*
 * Decompiled with CFR 0.152.
 */
package me.moocar.logbackgelf;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.Context;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Map;

public class GelfConverter {
    private final String facility;
    private final boolean useLoggerName;
    private final boolean useThreadName;
    private final boolean useMarker;
    private final Map<String, String> additionalFields;
    private final Map<String, String> staticAdditionalFields;
    private final int shortMessageLength;
    private final String hostname;
    private final Gson gson;
    private final PatternLayout patternLayout;
    private final PatternLayout shortPatternLayout;
    private boolean includeFullMDC;

    public GelfConverter(String facility, boolean useLoggerName, boolean useThreadName, boolean useMarker, Map<String, String> additionalFields, Map<String, String> staticAdditionalFields, int shortMessageLength, String hostname, String messagePattern, String shortMessagePattern, boolean includeFullMDC) {
        this.facility = facility;
        this.useLoggerName = useLoggerName;
        this.useMarker = useMarker;
        this.useThreadName = useThreadName;
        this.additionalFields = additionalFields;
        this.staticAdditionalFields = staticAdditionalFields;
        this.shortMessageLength = shortMessageLength;
        this.hostname = hostname;
        this.includeFullMDC = includeFullMDC;
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        this.gson = gsonBuilder.create();
        this.patternLayout = new PatternLayout();
        this.patternLayout.setContext((Context)new LoggerContext());
        this.patternLayout.setPattern(messagePattern);
        this.patternLayout.start();
        if (shortMessagePattern == null) {
            this.shortPatternLayout = null;
        } else {
            this.shortPatternLayout = new PatternLayout();
            this.shortPatternLayout.setContext((Context)new LoggerContext());
            this.shortPatternLayout.setPattern(shortMessagePattern);
            this.shortPatternLayout.start();
        }
    }

    public String toGelf(ILoggingEvent logEvent) {
        try {
            return this.gson.toJson(this.mapFields(logEvent));
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Error creating JSON message", e);
        }
    }

    private Map<String, Object> mapFields(ILoggingEvent logEvent) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("facility", this.facility);
        map.put("host", this.hostname);
        String message = this.patternLayout.doLayout(logEvent);
        map.put("full_message", message);
        map.put("short_message", this.truncateToShortMessage(message, logEvent));
        double logEventTimeTimeStamp = (double)logEvent.getTimeStamp() / 1000.0;
        this.stackTraceField(map, logEvent);
        map.put("timestamp", logEventTimeTimeStamp);
        map.put("version", "1.0");
        map.put("level", LevelToSyslogSeverity.convert((ILoggingEvent)logEvent));
        this.additionalFields(map, logEvent);
        this.staticAdditionalFields(map);
        return map;
    }

    private void stackTraceField(Map<String, Object> map, ILoggingEvent eventObject) {
        StackTraceElement[] callStackTraces;
        StackTraceElementProxy[] proxyStackTraces;
        IThrowableProxy throwableProxy = eventObject.getThrowableProxy();
        if (throwableProxy != null && (proxyStackTraces = throwableProxy.getStackTraceElementProxyArray()) != null && proxyStackTraces.length > 0 && (callStackTraces = eventObject.getCallerData()).length > 0) {
            StackTraceElement lastStack = callStackTraces[0];
            map.put("file", lastStack.getFileName());
            map.put("line", String.valueOf(lastStack.getLineNumber()));
        }
    }

    private void additionalFields(Map<String, Object> map, ILoggingEvent eventObject) {
        block8: {
            Map mdc;
            if (this.useLoggerName) {
                map.put("_loggerName", eventObject.getLoggerName());
            }
            if (this.useMarker && this.eventHasMarker(eventObject)) {
                map.put("_marker", eventObject.getMarker().toString());
            }
            if (this.useThreadName) {
                map.put("_threadName", eventObject.getThreadName());
            }
            if ((mdc = eventObject.getMDCPropertyMap()) == null) break block8;
            if (this.includeFullMDC) {
                for (Map.Entry e : mdc.entrySet()) {
                    if (this.additionalFields.containsKey(e.getKey())) {
                        map.put(this.additionalFields.get(e.getKey()), e.getValue());
                        continue;
                    }
                    map.put("_" + (String)e.getKey(), e.getValue());
                }
            } else {
                for (String key : this.additionalFields.keySet()) {
                    String field = (String)mdc.get(key);
                    if (field == null) continue;
                    map.put(this.additionalFields.get(key), field);
                }
            }
        }
    }

    private boolean eventHasMarker(ILoggingEvent eventObject) {
        return eventObject.getMarker() != null;
    }

    private void staticAdditionalFields(Map<String, Object> map) {
        for (String key : this.staticAdditionalFields.keySet()) {
            map.put(key, this.staticAdditionalFields.get(key));
        }
    }

    private String truncateToShortMessage(String fullMessage, ILoggingEvent logEvent) {
        if (this.shortPatternLayout != null) {
            return this.shortPatternLayout.doLayout(logEvent);
        }
        if (fullMessage.length() > this.shortMessageLength) {
            return fullMessage.substring(0, this.shortMessageLength);
        }
        return fullMessage;
    }
}

