/*
 * Decompiled with CFR 0.152.
 */
package me.lynnchurch.library;

import android.content.Context;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import me.lynnchurch.library.FloatingActionButtonMenu;
import me.lynnchurch.library.R;

public class ScrollAwareFABMenuBehavior
extends CoordinatorLayout.Behavior<FloatingActionButtonMenu> {
    private static final Interpolator INTERPOLATOR = new FastOutSlowInInterpolator();
    private boolean mIsAnimatingOut = false;

    public ScrollAwareFABMenuBehavior(Context context, AttributeSet attrs) {
    }

    public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, FloatingActionButtonMenu child, View directTargetChild, View target, int nestedScrollAxes) {
        return nestedScrollAxes == 2 || super.onStartNestedScroll(coordinatorLayout, (View)child, directTargetChild, target, nestedScrollAxes);
    }

    public void onNestedScroll(CoordinatorLayout coordinatorLayout, FloatingActionButtonMenu child, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        super.onNestedScroll(coordinatorLayout, (View)child, target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
        if (dyConsumed > 5 && !this.mIsAnimatingOut && child.getVisibility() == 0) {
            if (child.isExpanded()) {
                child.collapse();
            }
            this.animateOut(child);
        } else if (dyConsumed < -5 && child.getVisibility() != 0) {
            this.animateIn(child);
        }
    }

    private void animateOut(final FloatingActionButtonMenu menu) {
        Animation anim2 = AnimationUtils.loadAnimation((Context)menu.getContext(), (int)R.anim.hide_to_bottom);
        anim2.setInterpolator(INTERPOLATOR);
        anim2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                ScrollAwareFABMenuBehavior.this.mIsAnimatingOut = true;
            }

            public void onAnimationEnd(Animation animation) {
                ScrollAwareFABMenuBehavior.this.mIsAnimatingOut = false;
                menu.setVisibility(8);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        menu.startAnimation(anim2);
    }

    private void animateIn(FloatingActionButtonMenu menu) {
        menu.setVisibility(0);
        Animation anim2 = AnimationUtils.loadAnimation((Context)menu.getContext(), (int)R.anim.show_from_bottom);
        anim2.setInterpolator(INTERPOLATOR);
        menu.startAnimation(anim2);
    }
}

