/*
 * Decompiled with CFR 0.152.
 */
package me.lynnchurch.library;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.support.design.R;
import android.support.design.widget.FloatingActionButton;
import android.support.v7.widget.LinearLayoutCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.OvershootInterpolator;
import java.util.ArrayList;
import me.lynnchurch.library.R;

public class FloatingActionButtonMenu
extends LinearLayoutCompat {
    private static final String TAG = FloatingActionButtonMenu.class.getSimpleName();
    private static final int ITEM_DELAY = 70;
    private static final int ITEM_ANIM_DURATION = 100;
    private FloatingActionButton mSwitchButton;
    private boolean mExpanded = false;
    private boolean mIsAnimRunning = false;
    private OnMenuItemClickListener mOnMenuItemClickListener;

    public FloatingActionButtonMenu(Context context) {
        this(context, null);
    }

    public FloatingActionButtonMenu(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FloatingActionButtonMenu(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (null == this.mSwitchButton) {
            this.mSwitchButton = new FloatingActionButton(this.getContext());
            this.mSwitchButton.setImageResource(R.drawable.ic_add_white_18dp);
            int size = (int)this.getResources().getDimension(R.dimen.design_fab_size_normal);
            LinearLayoutCompat.LayoutParams params = new LinearLayoutCompat.LayoutParams(size, size);
            params.leftMargin = this.getResources().getDimensionPixelSize(R.dimen.fab_margin);
            params.topMargin = this.getResources().getDimensionPixelSize(R.dimen.fab_margin);
            params.rightMargin = this.getResources().getDimensionPixelSize(R.dimen.fab_margin);
            params.bottomMargin = this.getResources().getDimensionPixelSize(R.dimen.fab_margin);
            this.mSwitchButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (FloatingActionButtonMenu.this.mExpanded && !FloatingActionButtonMenu.this.mIsAnimRunning) {
                        FloatingActionButtonMenu.this.collapse(view);
                    } else if (!FloatingActionButtonMenu.this.mExpanded && !FloatingActionButtonMenu.this.mIsAnimRunning) {
                        FloatingActionButtonMenu.this.expand(view);
                    }
                }
            });
            this.addView((View)this.mSwitchButton, (ViewGroup.LayoutParams)params);
            this.initMenuItems();
            this.hideMenuItems();
        }
    }

    private void initMenuItems() {
        for (int i = 0; i < this.getChildCount() - 1; ++i) {
            View item = this.getChildAt(i);
            item.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (null != FloatingActionButtonMenu.this.mOnMenuItemClickListener) {
                        FloatingActionButtonMenu.this.mOnMenuItemClickListener.onMenuItemClick((FloatingActionButton)view, view.getId());
                    }
                    FloatingActionButtonMenu.this.collapse((View)FloatingActionButtonMenu.this.mSwitchButton);
                }
            });
            LinearLayoutCompat.LayoutParams params = (LinearLayoutCompat.LayoutParams)item.getLayoutParams();
            params.topMargin = this.getResources().getDimensionPixelSize(R.dimen.fab_margin);
        }
    }

    private void hideMenuItems() {
        for (int i = 0; i < this.getChildCount() - 1; ++i) {
            View item = this.getChildAt(i);
            item.setScaleX(0.0f);
            item.setScaleY(0.0f);
            item.setVisibility(8);
        }
    }

    private void showMenuItems() {
        for (int i = 0; i < this.getChildCount() - 1; ++i) {
            View item = this.getChildAt(i);
            item.setVisibility(0);
        }
    }

    public void expand(View v) {
        this.mExpanded = true;
        ArrayList<ObjectAnimator> itemAnims = new ArrayList<ObjectAnimator>();
        AnimatorSet set = new AnimatorSet();
        ObjectAnimator switchAnim = ObjectAnimator.ofFloat((Object)v, (String)"rotation", (float[])new float[]{-225.0f});
        switchAnim.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        itemAnims.add(switchAnim);
        this.showMenuItems();
        for (int i = this.getChildCount() - 2; i >= 0; --i) {
            View item = this.getChildAt(i);
            PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{0.0f, 1.0f});
            PropertyValuesHolder scaleY = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{0.0f, 1.0f});
            ObjectAnimator itemAnim = ObjectAnimator.ofPropertyValuesHolder((Object)item, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX, scaleY});
            itemAnim.setDuration(100L);
            itemAnim.setStartDelay((long)(70 * (this.getChildCount() - 1 - i)));
            itemAnim.setInterpolator((TimeInterpolator)new OvershootInterpolator());
            itemAnims.add(itemAnim);
        }
        set.playTogether(itemAnims);
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                FloatingActionButtonMenu.this.mIsAnimRunning = true;
            }

            public void onAnimationEnd(Animator animator) {
                FloatingActionButtonMenu.this.mIsAnimRunning = false;
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        set.start();
    }

    public void collapse(View v) {
        this.mExpanded = false;
        ArrayList<ObjectAnimator> itemAnims = new ArrayList<ObjectAnimator>();
        AnimatorSet set = new AnimatorSet();
        ObjectAnimator switchAnim = ObjectAnimator.ofFloat((Object)v, (String)"rotation", (float[])new float[]{0.0f});
        switchAnim.setInterpolator((TimeInterpolator)new AnticipateOvershootInterpolator());
        itemAnims.add(switchAnim);
        for (int i = 0; i < this.getChildCount() - 1; ++i) {
            View item = this.getChildAt(i);
            PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 0.0f});
            PropertyValuesHolder scaleY = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f, 0.0f});
            ObjectAnimator itemAnim = ObjectAnimator.ofPropertyValuesHolder((Object)item, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX, scaleY});
            itemAnim.setDuration(100L);
            itemAnim.setStartDelay((long)(70 * i));
            itemAnims.add(itemAnim);
        }
        set.playTogether(itemAnims);
        set.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                FloatingActionButtonMenu.this.mIsAnimRunning = true;
            }

            public void onAnimationEnd(Animator animator) {
                FloatingActionButtonMenu.this.hideMenuItems();
                FloatingActionButtonMenu.this.mIsAnimRunning = false;
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        set.start();
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener listener) {
        this.mOnMenuItemClickListener = listener;
    }

    public static interface OnMenuItemClickListener {
        public void onMenuItemClick(FloatingActionButton var1, int var2);
    }
}

