/*
 * Decompiled with CFR 0.152.
 */
package me.linshen.android.widget;

import android.content.Context;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.List;

public class OverScrollViewPager
extends ViewPager {
    private static final String TAG = "OverScrollViewPager";
    private static final boolean DEBUG = false;
    private GestureDetectorCompat mDetector;
    private List<OnPageOverScrollListener> mOnPageOverScrollListeners;
    private OnPageOverScrollListener mOnPageOverScrollListener;
    private SCROLL_STATE mState;

    public OverScrollViewPager(Context context) {
        super(context, null);
        this.init(context);
    }

    public OverScrollViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)new GestureListener());
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.mDetector.onTouchEvent(ev);
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.mDetector.onTouchEvent(ev);
        if (MotionEventCompat.getActionMasked((MotionEvent)ev) == 1) {
            this.mState = SCROLL_STATE.IDLE;
        }
        return super.onTouchEvent(ev);
    }

    public void addOnPageOverScrollListener(OnPageOverScrollListener listener) {
        if (this.mOnPageOverScrollListeners == null) {
            this.mOnPageOverScrollListeners = new ArrayList<OnPageOverScrollListener>();
        }
        this.mOnPageOverScrollListeners.add(listener);
    }

    public void removeOnPageOverScrollListener(OnPageOverScrollListener listener) {
        if (this.mOnPageOverScrollListeners != null) {
            this.mOnPageOverScrollListeners.remove(listener);
        }
    }

    public void clearOnPageOverScrollListeners() {
        if (this.mOnPageOverScrollListeners != null) {
            this.mOnPageOverScrollListeners.clear();
        }
    }

    private void onPageOverScroll(SCROLL_STATE state) {
        if (this.mState != state) {
            this.dispatchOnPageOverScrolled(state);
            this.mState = state;
        }
    }

    private void dispatchOnPageOverScrolled(SCROLL_STATE state) {
        if (this.mOnPageOverScrollListeners != null) {
            int z = this.mOnPageOverScrollListeners.size();
            for (int i = 0; i < z; ++i) {
                OnPageOverScrollListener listener = this.mOnPageOverScrollListeners.get(i);
                if (listener == null) continue;
                listener.onPageOverScrolled(state);
            }
        }
    }

    public static interface OnPageOverScrollListener {
        public void onPageOverScrolled(SCROLL_STATE var1);
    }

    public static enum SCROLL_STATE {
        LEFT,
        RIGHT,
        IDLE;

    }

    class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (Math.abs(distanceX) > Math.abs(distanceY)) {
                if (OverScrollViewPager.this.getCurrentItem() == 0) {
                    if (e1 != null && e2 != null && e1.getX() < e2.getX()) {
                        OverScrollViewPager.this.onPageOverScroll(SCROLL_STATE.LEFT);
                    }
                } else if (OverScrollViewPager.this.getAdapter() != null && OverScrollViewPager.this.getCurrentItem() == OverScrollViewPager.this.getAdapter().getCount() - 1 && e1 != null && e2 != null && e1.getX() > e2.getX()) {
                    OverScrollViewPager.this.onPageOverScroll(SCROLL_STATE.RIGHT);
                }
            }
            return super.onScroll(e1, e2, distanceX, distanceY);
        }
    }
}

