/*
 * Decompiled with CFR 0.152.
 */
package me.leon.rxbus;

import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RxBus2 {
    private static volatile RxBus2 mDefaultInstance;
    private final Subject mBus = PublishSubject.create().toSerialized();
    private final Map<Class<?>, Object> mStickyEventMap = new ConcurrentHashMap();

    private RxBus2() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RxBus2 getDefault() {
        if (mDefaultInstance != null) return mDefaultInstance;
        Class<RxBus2> clazz = RxBus2.class;
        synchronized (RxBus2.class) {
            if (mDefaultInstance != null) return mDefaultInstance;
            mDefaultInstance = new RxBus2();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mDefaultInstance;
        }
    }

    public void post(Object event) {
        this.mBus.onNext(event);
    }

    public <T> Observable<T> registerEvent(Class<T> eventType) {
        return this.mBus.ofType(eventType);
    }

    public boolean hasObservers() {
        return this.mBus.hasObservers();
    }

    public void unregister() {
        mDefaultInstance = null;
    }

    public void postSticky(Object event) {
        this.mStickyEventMap.put(event.getClass(), event);
        this.post(event);
    }

    public <T> Observable<T> registerStickyEvent(final Class<T> eventType) {
        Observable observable = this.mBus.ofType(eventType);
        final Object event = this.mStickyEventMap.get(eventType);
        if (event != null) {
            return observable.mergeWith((ObservableSource)Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(){

                public void subscribe(ObservableEmitter<T> subscriber) throws Exception {
                    subscriber.onNext(eventType.cast(event));
                }
            }));
        }
        return observable;
    }

    public <T> T getStickyEvent(Class<T> eventType) {
        return eventType.cast(this.mStickyEventMap.get(eventType));
    }

    public <T> T removeStickyEvent(Class<T> eventType) {
        return eventType.cast(this.mStickyEventMap.remove(eventType));
    }

    public void removeAllStickyEvents() {
        this.mStickyEventMap.clear();
    }
}

