/*
 * Decompiled with CFR 0.152.
 */
package me.leolin.shortcutbadger;

import android.app.Notification;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import me.leolin.shortcutbadger.Badger;
import me.leolin.shortcutbadger.ShortcutBadgeException;
import me.leolin.shortcutbadger.impl.AdwHomeBadger;
import me.leolin.shortcutbadger.impl.ApexHomeBadger;
import me.leolin.shortcutbadger.impl.AsusHomeBadger;
import me.leolin.shortcutbadger.impl.DefaultBadger;
import me.leolin.shortcutbadger.impl.EverythingMeHomeBadger;
import me.leolin.shortcutbadger.impl.HuaweiHomeBadger;
import me.leolin.shortcutbadger.impl.NewHtcHomeBadger;
import me.leolin.shortcutbadger.impl.NovaHomeBadger;
import me.leolin.shortcutbadger.impl.OPPOHomeBader;
import me.leolin.shortcutbadger.impl.SamsungHomeBadger;
import me.leolin.shortcutbadger.impl.SonyHomeBadger;
import me.leolin.shortcutbadger.impl.VivoHomeBadger;
import me.leolin.shortcutbadger.impl.ZTEHomeBadger;
import me.leolin.shortcutbadger.impl.ZukHomeBadger;

public final class ShortcutBadger {
    private static final String LOG_TAG = "ShortcutBadger";
    private static final int SUPPORTED_CHECK_ATTEMPTS = 3;
    private static final List<Class<? extends Badger>> BADGERS = new LinkedList<Class<? extends Badger>>();
    private static volatile Boolean sIsBadgeCounterSupported;
    private static final Object sCounterSupportedLock;
    private static Badger sShortcutBadger;
    private static ComponentName sComponentName;

    public static boolean applyCount(Context context, int badgeCount) {
        try {
            ShortcutBadger.applyCountOrThrow(context, badgeCount);
            return true;
        }
        catch (ShortcutBadgeException e) {
            if (Log.isLoggable((String)LOG_TAG, (int)3)) {
                Log.d((String)LOG_TAG, (String)"Unable to execute badge", (Throwable)e);
            }
            return false;
        }
    }

    public static void applyCountOrThrow(Context context, int badgeCount) throws ShortcutBadgeException {
        boolean launcherReady;
        if (sShortcutBadger == null && !(launcherReady = ShortcutBadger.initBadger(context))) {
            throw new ShortcutBadgeException("No default launcher available");
        }
        try {
            sShortcutBadger.executeBadge(context, sComponentName, badgeCount);
        }
        catch (Exception e) {
            throw new ShortcutBadgeException("Unable to execute badge", e);
        }
    }

    public static boolean removeCount(Context context) {
        return ShortcutBadger.applyCount(context, 0);
    }

    public static void removeCountOrThrow(Context context) throws ShortcutBadgeException {
        ShortcutBadger.applyCountOrThrow(context, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBadgeCounterSupported(Context context) {
        if (sIsBadgeCounterSupported == null) {
            Object object = sCounterSupportedLock;
            synchronized (object) {
                if (sIsBadgeCounterSupported == null) {
                    String lastErrorMessage = null;
                    for (int i = 0; i < 3; ++i) {
                        try {
                            Log.i((String)LOG_TAG, (String)("Checking if platform supports badge counters, attempt " + String.format("%d/%d.", i + 1, 3)));
                            if (ShortcutBadger.initBadger(context)) {
                                sShortcutBadger.executeBadge(context, sComponentName, 0);
                                sIsBadgeCounterSupported = true;
                                Log.i((String)LOG_TAG, (String)"Badge counter is supported in this platform.");
                                break;
                            }
                            lastErrorMessage = "Failed to initialize the badge counter.";
                            continue;
                        }
                        catch (Exception e) {
                            lastErrorMessage = e.getMessage();
                        }
                    }
                    if (sIsBadgeCounterSupported == null) {
                        Log.w((String)LOG_TAG, (String)("Badge counter seems not supported for this platform: " + lastErrorMessage));
                        sIsBadgeCounterSupported = false;
                    }
                }
            }
        }
        return sIsBadgeCounterSupported;
    }

    public static void applyNotification(Context context, Notification notification, int badgeCount) {
        block3: {
            if (Build.MANUFACTURER.equalsIgnoreCase("Xiaomi")) {
                try {
                    Field field = notification.getClass().getDeclaredField("extraNotification");
                    Object extraNotification = field.get(notification);
                    Method method = extraNotification.getClass().getDeclaredMethod("setMessageCount", Integer.TYPE);
                    method.invoke(extraNotification, badgeCount);
                }
                catch (Exception e) {
                    if (!Log.isLoggable((String)LOG_TAG, (int)3)) break block3;
                    Log.d((String)LOG_TAG, (String)"Unable to execute badge", (Throwable)e);
                }
            }
        }
    }

    private static boolean initBadger(Context context) {
        Intent launchIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        if (launchIntent == null) {
            Log.e((String)LOG_TAG, (String)("Unable to find launch intent for package " + context.getPackageName()));
            return false;
        }
        sComponentName = launchIntent.getComponent();
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        List resolveInfos = context.getPackageManager().queryIntentActivities(intent, 65536);
        for (ResolveInfo resolveInfo : resolveInfos) {
            String currentHomePackage = resolveInfo.activityInfo.packageName;
            for (Class<? extends Badger> badger : BADGERS) {
                Badger shortcutBadger = null;
                try {
                    shortcutBadger = badger.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (shortcutBadger == null || !shortcutBadger.getSupportLaunchers().contains(currentHomePackage)) continue;
                sShortcutBadger = shortcutBadger;
                break;
            }
            if (sShortcutBadger == null) continue;
            break;
        }
        if (sShortcutBadger == null) {
            sShortcutBadger = Build.MANUFACTURER.equalsIgnoreCase("ZUK") ? new ZukHomeBadger() : (Build.MANUFACTURER.equalsIgnoreCase("OPPO") ? new OPPOHomeBader() : (Build.MANUFACTURER.equalsIgnoreCase("VIVO") ? new VivoHomeBadger() : (Build.MANUFACTURER.equalsIgnoreCase("ZTE") ? new ZTEHomeBadger() : new DefaultBadger())));
        }
        return true;
    }

    private ShortcutBadger() {
    }

    static {
        sCounterSupportedLock = new Object();
        BADGERS.add(AdwHomeBadger.class);
        BADGERS.add(ApexHomeBadger.class);
        BADGERS.add(DefaultBadger.class);
        BADGERS.add(NewHtcHomeBadger.class);
        BADGERS.add(NovaHomeBadger.class);
        BADGERS.add(SonyHomeBadger.class);
        BADGERS.add(AsusHomeBadger.class);
        BADGERS.add(HuaweiHomeBadger.class);
        BADGERS.add(OPPOHomeBader.class);
        BADGERS.add(SamsungHomeBadger.class);
        BADGERS.add(ZukHomeBadger.class);
        BADGERS.add(VivoHomeBadger.class);
        BADGERS.add(ZTEHomeBadger.class);
        BADGERS.add(EverythingMeHomeBadger.class);
    }
}

