/*
 * Decompiled with CFR 0.152.
 */
package me.leolin.shortcutbadger.impl;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Build;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import me.leolin.shortcutbadger.Badger;
import me.leolin.shortcutbadger.ShortcutBadgeException;
import me.leolin.shortcutbadger.util.BroadcastHelper;

public class XiaomiHomeBadger
implements Badger {
    public static final String INTENT_ACTION = "android.intent.action.APPLICATION_MESSAGE_UPDATE";
    public static final String EXTRA_UPDATE_APP_COMPONENT_NAME = "android.intent.extra.update_application_component_name";
    public static final String EXTRA_UPDATE_APP_MSG_TEXT = "android.intent.extra.update_application_message_text";
    private ResolveInfo resolveInfo;

    @Override
    public void executeBadge(Context context, ComponentName componentName, int badgeCount) throws ShortcutBadgeException {
        block5: {
            try {
                Class<?> miuiNotificationClass = Class.forName("android.app.MiuiNotification");
                Object miuiNotification = miuiNotificationClass.newInstance();
                Field field = miuiNotification.getClass().getDeclaredField("messageCount");
                field.setAccessible(true);
                try {
                    field.set(miuiNotification, String.valueOf(badgeCount == 0 ? "" : Integer.valueOf(badgeCount)));
                }
                catch (Exception e) {
                    field.set(miuiNotification, badgeCount);
                }
            }
            catch (Exception e) {
                Intent localIntent = new Intent(INTENT_ACTION);
                localIntent.putExtra(EXTRA_UPDATE_APP_COMPONENT_NAME, componentName.getPackageName() + "/" + componentName.getClassName());
                localIntent.putExtra(EXTRA_UPDATE_APP_MSG_TEXT, String.valueOf(badgeCount == 0 ? "" : Integer.valueOf(badgeCount)));
                if (BroadcastHelper.canResolveBroadcast(context, localIntent)) {
                    context.sendBroadcast(localIntent);
                }
                if (!Build.MANUFACTURER.equalsIgnoreCase("Xiaomi")) break block5;
                this.tryNewMiuiBadge(context, badgeCount);
            }
        }
    }

    @TargetApi(value=16)
    private void tryNewMiuiBadge(Context context, int badgeCount) {
        if (this.resolveInfo == null) {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.addCategory("android.intent.category.HOME");
            this.resolveInfo = context.getPackageManager().resolveActivity(intent, 65536);
        }
        if (this.resolveInfo != null) {
            NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
            Notification.Builder builder = new Notification.Builder(context).setContentTitle((CharSequence)context.getString(this.resolveInfo.labelRes)).setContentText((CharSequence)context.getString(this.resolveInfo.labelRes)).setSmallIcon(this.resolveInfo.getIconResource());
            Notification notification = builder.build();
            try {
                Field field = notification.getClass().getDeclaredField("extraNotification");
                Object extraNotification = field.get(notification);
                Method method = extraNotification.getClass().getDeclaredMethod("setMessageCount", Integer.TYPE);
                method.invoke(extraNotification, badgeCount);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            mNotificationManager.notify(0, notification);
        }
    }

    @Override
    public List<String> getSupportLaunchers() {
        return Arrays.asList("com.miui.miuilite", "com.miui.home", "com.miui.miuihome", "com.miui.miuihome2", "com.miui.mihome", "com.miui.mihome2", "com.i.miui.launcher");
    }
}

