/*
 * Decompiled with CFR 0.152.
 */
package me.leolin.shortcutbadger;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Build;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import me.leolin.shortcutbadger.ShortcutBadgeException;
import me.leolin.shortcutbadger.impl.AdwHomeBadger;
import me.leolin.shortcutbadger.impl.Android2HomeBadger;
import me.leolin.shortcutbadger.impl.AndroidHomeBadger;
import me.leolin.shortcutbadger.impl.ApexHomeBadger;
import me.leolin.shortcutbadger.impl.LGHomeBadger;
import me.leolin.shortcutbadger.impl.NewHtcHomeBadger;
import me.leolin.shortcutbadger.impl.NovaHomeBadger;
import me.leolin.shortcutbadger.impl.SamsungHomeBadger;
import me.leolin.shortcutbadger.impl.SolidHomeBadger;
import me.leolin.shortcutbadger.impl.SonyHomeBadger;
import me.leolin.shortcutbadger.impl.XiaomiHomeBadger;

public abstract class ShortcutBadger {
    private static final List<Class<? extends ShortcutBadger>> BADGERS = new LinkedList<Class<? extends ShortcutBadger>>();
    private static final String MESSAGE_NOT_SUPPORT_BADGE_COUNT = "ShortBadger is currently not support the badgeCount \"%d\"";
    private static final String MESSAGE_NOT_SUPPORT_THIS_HOME = "ShortcutBadger is currently not support the home launcher package \"%s\"";
    private static final int MIN_BADGE_COUNT = 0;
    private static final int MAX_BADGE_COUNT = 99;
    private static ShortcutBadger mShortcutBadger;
    protected Context mContext;

    private ShortcutBadger() {
    }

    protected ShortcutBadger(Context context) {
        this.mContext = context;
    }

    protected abstract void executeBadge(int var1) throws ShortcutBadgeException;

    public static void setBadge(Context context, int badgeCount) throws ShortcutBadgeException {
        if (badgeCount < 0 || badgeCount > 99) {
            String exceptionMessage = String.format(MESSAGE_NOT_SUPPORT_BADGE_COUNT, badgeCount);
            throw new ShortcutBadgeException(exceptionMessage);
        }
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 65536);
        String currentHomePackage = resolveInfo.activityInfo.packageName;
        try {
            ShortcutBadger shortcutBadger = ShortcutBadger.getShortcutBadger(currentHomePackage, context);
            if (shortcutBadger == null) {
                String exceptionMessage = String.format(MESSAGE_NOT_SUPPORT_THIS_HOME, currentHomePackage);
                throw new ShortcutBadgeException(exceptionMessage);
            }
            shortcutBadger.executeBadge(badgeCount);
        }
        catch (Throwable e) {
            throw new ShortcutBadgeException("Unable to execute badge:" + e.getMessage());
        }
    }

    private static ShortcutBadger getShortcutBadger(String currentHomePackage, Context context) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        if (mShortcutBadger != null) {
            return mShortcutBadger;
        }
        if (Build.MANUFACTURER.toLowerCase().contains("meizu")) {
            return null;
        }
        if (Build.MANUFACTURER.equalsIgnoreCase("Xiaomi")) {
            mShortcutBadger = new XiaomiHomeBadger(context);
            return mShortcutBadger;
        }
        for (Class<? extends ShortcutBadger> badger : BADGERS) {
            Constructor<? extends ShortcutBadger> constructor = badger.getConstructor(Context.class);
            ShortcutBadger shortcutBadger = constructor.newInstance(context);
            if (!shortcutBadger.getSupportLaunchers().contains(currentHomePackage)) continue;
            mShortcutBadger = shortcutBadger;
            break;
        }
        return mShortcutBadger;
    }

    public abstract List<String> getSupportLaunchers();

    protected String getEntryActivityName() {
        ComponentName componentName = this.mContext.getPackageManager().getLaunchIntentForPackage(this.mContext.getPackageName()).getComponent();
        return componentName.getClassName();
    }

    protected String getContextPackageName() {
        return this.mContext.getPackageName();
    }

    static {
        BADGERS.add(AdwHomeBadger.class);
        BADGERS.add(AndroidHomeBadger.class);
        BADGERS.add(Android2HomeBadger.class);
        BADGERS.add(ApexHomeBadger.class);
        BADGERS.add(LGHomeBadger.class);
        BADGERS.add(NewHtcHomeBadger.class);
        BADGERS.add(NovaHomeBadger.class);
        BADGERS.add(SamsungHomeBadger.class);
        BADGERS.add(SolidHomeBadger.class);
        BADGERS.add(SonyHomeBadger.class);
        BADGERS.add(XiaomiHomeBadger.class);
    }
}

