/*
 * Decompiled with CFR 0.152.
 */
package me.leolin.shortcutbadger.util;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import me.leolin.shortcutbadger.ShortcutBadgeException;

public class ImageUtil {
    public static Bitmap drawableToBitmap(Drawable drawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    public static byte[] bitmapToByteArray(Bitmap bitmap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static byte[] drawBadgeOnAppIcon(Context context, int badgeCount) throws ShortcutBadgeException {
        float height;
        float width;
        Bitmap appIcon;
        String gText = String.valueOf(badgeCount);
        try {
            Drawable iconDrawable = context.getPackageManager().getApplicationIcon(context.getPackageName());
            appIcon = ImageUtil.drawableToBitmap(iconDrawable);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new ShortcutBadgeException("Could not load the app Icon");
        }
        if (appIcon == null) {
            throw new ShortcutBadgeException("Could not load the app Icon");
        }
        if (badgeCount == 0) {
            return ImageUtil.bitmapToByteArray(appIcon);
        }
        float scale = context.getResources().getDisplayMetrics().density;
        Bitmap.Config bitmapConfig = appIcon.getConfig();
        if (bitmapConfig == null) {
            bitmapConfig = Bitmap.Config.ARGB_8888;
        }
        float radius = ((width = (float)(appIcon = appIcon.copy(bitmapConfig, true)).getWidth()) > (height = (float)appIcon.getHeight()) ? width : height) / 4.0f;
        float cx = (float)appIcon.getWidth() - radius;
        float cy = radius;
        Canvas canvas = new Canvas(appIcon);
        Paint paint = new Paint(1);
        paint.setColor(-1);
        canvas.drawCircle(cx, cy, radius, paint);
        paint.setColor(-65536);
        canvas.drawCircle(cx, cy, radius * 6.0f / 7.0f, paint);
        paint.setColor(-1);
        int textSize = (int)((double)radius * 0.7);
        if (gText.length() > 1) {
            textSize = (int)((double)radius * 0.5);
        }
        paint.setTextSize((float)((int)((float)textSize * scale)));
        paint.setFakeBoldText(true);
        Rect bounds = new Rect();
        paint.getTextBounds(gText, 0, gText.length(), bounds);
        float bw = bounds.width() / 2;
        if (gText.endsWith("1")) {
            bw = (float)((double)bw * 1.25);
        }
        float bh = bounds.height() / 2;
        canvas.drawText(gText, cx - bw, cy + bh, paint);
        return ImageUtil.bitmapToByteArray(appIcon);
    }
}

