/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.log;

import java.util.Date;
import java.util.function.Supplier;
import me.legrange.log.Event;
import me.legrange.log.Level;
import me.legrange.log.Logger;
import me.legrange.log.PackageLogger;
import me.legrange.log.Router;

public final class Log {
    public static void critical(String fmt, Object ... args) {
        Log.log(Level.CRITICAL, fmt, args);
    }

    public static void critical(Throwable ex) {
        Log.log(Level.CRITICAL, ex, ex.getMessage(), new Object[0]);
    }

    public static void critical(Throwable ex, String fmt, Object ... args) {
        Log.log(Level.CRITICAL, ex, fmt, args);
    }

    public static void error(String fmt, Object ... args) {
        Log.log(Level.ERROR, fmt, args);
    }

    public static void error(Throwable ex) {
        Log.log(Level.ERROR, ex, ex.getMessage(), new Object[0]);
    }

    public static void error(Throwable ex, String fmt, Object ... args) {
        Log.log(Level.ERROR, ex, fmt, args);
    }

    public static void warning(String fmt, Object ... args) {
        Log.log(Level.WARNING, fmt, args);
    }

    public static void warning(Throwable ex) {
        Log.log(Level.WARNING, ex, ex.getMessage(), new Object[0]);
    }

    public static void warning(Throwable ex, String fmt, Object ... args) {
        Log.log(Level.WARNING, ex, fmt, args);
    }

    public static void info(String fmt, Object ... args) {
        Log.log(Level.INFO, fmt, args);
    }

    public static void debug(String fmt, Object ... args) {
        Log.log(Level.DEBUG, fmt, args);
    }

    public static void debug(Supplier<String> msg) {
        Log.log(Level.DEBUG, () -> new Event((String)msg.get(), new Date(), Level.DEBUG, null));
    }

    public static void setDefaultLogger(Logger logger) {
        Router.getInstance().setDefaultLogger(logger);
    }

    public static void setDefaultLevel(Level level) {
        Router.getInstance().setDefaultLevel(level);
    }

    public static void setLogger(Logger logger) {
        Router.getInstance().setLogger(logger);
    }

    public static void setLogger(String name, Logger logger) {
        Router.getInstance().setLogger(name, logger);
    }

    public static void setLevel(Level level) {
        Router.getInstance().setLevel(level);
    }

    public static void setLevel(String name, Level level) {
        Router.getInstance().setLevel(name, level);
    }

    private static void log(Level level, String fmt, Object ... args) {
        Log.log(level, () -> new Event(String.format(fmt, args), new Date(), level, null));
    }

    private static void log(Level level, Throwable ex, String fmt, Object ... args) {
        String strFmt = fmt != null ? fmt : "";
        Log.log(level, () -> new Event(String.format(strFmt, args), new Date(), level, ex));
    }

    private static void log(Level level, Supplier<Event> entry) {
        PackageLogger pl = Router.getInstance().route();
        if (level.code() <= pl.getLevel().code()) {
            try {
                pl.getLogger().log(entry.get());
            }
            catch (Throwable ex) {
                StackTraceElement el = Log.findErrorLine(ex);
                pl.getLogger().log(new Event(String.format("Error while logging at %s:%d: '%s'", el.getFileName(), el.getLineNumber(), ex.getMessage()), new Date(), Level.ERROR, ex));
            }
        }
    }

    private static StackTraceElement findErrorLine(Throwable ex) {
        StackTraceElement[] els = ex.getStackTrace();
        boolean foundMe = false;
        for (int i = 0; i < els.length; ++i) {
            StackTraceElement el = els[i];
            String className = el.getClassName();
            if (className.startsWith(Log.class.getName())) {
                foundMe = true;
                continue;
            }
            if (!foundMe) continue;
            return el;
        }
        return null;
    }
}

