/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.log.logger;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import me.legrange.log.Event;
import me.legrange.log.Logger;
import me.legrange.log.logger.LoggerException;

public class FileLogger
implements Logger {
    private final PrintWriter out;
    private final String fileName;

    public FileLogger(String fileName) throws LoggerException {
        this.out = this.openFile(fileName);
        this.fileName = fileName;
    }

    @Override
    public void log(Event entry) {
        this.out.printf("%s [%s]: %s\n", new Object[]{entry.getTimestamp(), entry.getLevel(), entry.getMessage()});
        this.out.flush();
    }

    @Override
    public String getName() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.fileName);
    }

    private final PrintWriter openFile(String fileName) throws LoggerException {
        try {
            return new PrintWriter(new FileWriter(fileName, true));
        }
        catch (IOException ex) {
            throw new LoggerException(String.format("Error opening log file '%s': %s", fileName, ex.getMessage()), ex);
        }
    }
}

