/*
 * Decompiled with CFR 0.152.
 */
package me.ledge.link.api.vos.datapoints;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rits.cloning.Cloner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import me.ledge.link.api.vos.datapoints.DataPointVo;

public class DataPointList {
    private HashMap<DataPointVo.DataPointType, List<DataPointVo>> dataPoints;

    public DataPointList() {
        this.dataPoints = new HashMap();
    }

    public DataPointList(DataPointList copyInstance) {
        if (copyInstance == null) {
            return;
        }
        Cloner cloner = new Cloner();
        this.dataPoints = (HashMap)cloner.deepClone(copyInstance.dataPoints);
    }

    public void init() {
        this.dataPoints = null;
    }

    public void add(DataPointVo dataPoint) {
        if (this.dataPoints.containsKey((Object)dataPoint.getType())) {
            List<DataPointVo> dataPointList = this.getDataPointsOf(dataPoint.getType());
            if (!dataPointList.contains(dataPoint)) {
                dataPointList.add(dataPoint);
            }
            this.dataPoints.put(dataPoint.getType(), dataPointList);
        } else {
            this.dataPoints.put(dataPoint.getType(), new LinkedList<DataPointVo>(Arrays.asList(dataPoint)));
        }
    }

    public void removeDataPointsOf(DataPointVo.DataPointType type) {
        if (this.dataPoints.containsKey((Object)type)) {
            this.dataPoints.remove((Object)type);
        }
    }

    public DataPointVo getUniqueDataPoint(DataPointVo.DataPointType key, DataPointVo defaultValue) {
        if (this.dataPoints.containsKey((Object)key)) {
            return this.dataPoints.get((Object)key).get(0);
        }
        if (defaultValue != null) {
            this.dataPoints.put(key, new LinkedList<DataPointVo>(Arrays.asList(defaultValue)));
        }
        return defaultValue;
    }

    public List<DataPointVo> getDataPointsOf(DataPointVo.DataPointType key) {
        if (this.dataPoints.containsKey((Object)key)) {
            return this.dataPoints.get((Object)key);
        }
        return null;
    }

    public void setDataPoints(HashMap<DataPointVo.DataPointType, List<DataPointVo>> dataPoints) {
        this.dataPoints = dataPoints;
    }

    public HashMap<DataPointVo.DataPointType, List<DataPointVo>> getDataPoints() {
        return this.dataPoints;
    }

    public JsonObject toJSON() {
        JsonObject gsonObject = new JsonObject();
        JsonArray gsonArray = new JsonArray();
        for (List<DataPointVo> dataPoints : this.getDataPoints().values()) {
            for (DataPointVo dataPointVo : dataPoints) {
                gsonArray.add((JsonElement)dataPointVo.toJSON());
            }
        }
        gsonObject.add("data", (JsonElement)gsonArray);
        gsonObject.addProperty("type", "list");
        JsonObject result = new JsonObject();
        result.add("data_points", (JsonElement)gsonObject);
        return result;
    }
}

