/*
 * Decompiled with CFR 0.152.
 */
package me.kaneki.xchatmessageview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import me.kaneki.xchatmessageview.R;
import me.kaneki.xchatmessageview.anno.XItemLayoutResResolver;
import me.kaneki.xchatmessageview.holder.XMoreHolder;
import me.kaneki.xchatmessageview.holder.XViewHolder;

public abstract class XMessageAdapter<T>
extends RecyclerView.Adapter<XViewHolder<T>> {
    private static final int TYPE_LOADING_HEADER = 1000;
    private static final int TYPE_LOADING_FOOTER = 1001;
    private LayoutInflater layoutInflater;
    private ArrayList<T> mDatas;
    private int[] mIds;
    private int headerLayoutId;
    private int footerLayoutId;
    private boolean isNeedHeaderLoadMore;
    private boolean isNeedFooterLoadMore;

    public XMessageAdapter(Context context, ArrayList<T> mDatas) {
        this.mDatas = mDatas;
        this.mIds = XItemLayoutResResolver.resolve(this);
        this.layoutInflater = LayoutInflater.from((Context)context);
        this.headerLayoutId = R.layout.x_default_load;
        this.footerLayoutId = R.layout.x_default_load;
        this.isNeedHeaderLoadMore = false;
        this.isNeedFooterLoadMore = false;
    }

    public abstract int getItemViewType(T var1);

    public abstract XViewHolder<T> getViewHolder(View var1, int var2);

    public void setHeaderLayoutId(int headerLayoutId) {
        this.headerLayoutId = headerLayoutId;
    }

    public void setFooterLayoutId(int footerLayoutId) {
        this.footerLayoutId = footerLayoutId;
    }

    boolean isNeedHeaderLoadMore() {
        return this.isNeedHeaderLoadMore;
    }

    void setNeedHeaderLoadMore(boolean needHeaderLoadMore) {
        this.isNeedHeaderLoadMore = needHeaderLoadMore;
    }

    boolean isNeedFooterLoadMore() {
        return this.isNeedFooterLoadMore;
    }

    void setNeedFooterLoadMore(boolean needFooterLoadMore) {
        this.isNeedFooterLoadMore = needFooterLoadMore;
    }

    void addMessageAtLast(T t) {
        this.mDatas.add(t);
        this.notifyItemInserted(this.getItemCount());
    }

    void addMoreMessageAtLast(List<T> tList) {
        this.mDatas.addAll(tList);
        this.notifyItemInserted(this.getItemCount());
    }

    void addMoreMessageAtFirst(List<T> tList) {
        this.mDatas.addAll(0, tList);
        this.notifyItemRangeInserted(this.isNeedHeaderLoadMore ? 1 : 0, tList.size());
        this.notifyItemRangeChanged(tList.size() + (this.isNeedHeaderLoadMore ? 1 : 0), this.getItemCount() - tList.size());
    }

    void removeMessageAtPosition(int pos) {
        int realIndex = this.isNeedHeaderLoadMore ? pos - 1 : pos;
        this.mDatas.remove(realIndex);
        this.notifyItemRemoved(pos);
        if (realIndex != this.getItemCount() - 1) {
            this.notifyItemRangeChanged(realIndex, this.getItemCount() - realIndex);
        }
    }

    void removeAllMessage() {
        this.isNeedFooterLoadMore = false;
        this.isNeedHeaderLoadMore = false;
        this.mDatas.clear();
        this.notifyDataSetChanged();
    }

    public int getItemViewType(int position) {
        if (this.isNeedHeaderLoadMore && position == 0) {
            return 1000;
        }
        if (this.isNeedFooterLoadMore && position == this.getItemCount() - 1) {
            return 1001;
        }
        if (this.isNeedHeaderLoadMore) {
            return this.getItemViewType(this.mDatas.get(position - 1));
        }
        return this.getItemViewType(this.mDatas.get(position));
    }

    public XViewHolder<T> onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1000) {
            return new XMoreHolder(this.layoutInflater.inflate(this.headerLayoutId, parent, false)){

                @Override
                public void bindMoreView(Object object) {
                }
            };
        }
        if (viewType == 1001) {
            return new XMoreHolder(this.layoutInflater.inflate(this.footerLayoutId, parent, false)){

                @Override
                public void bindMoreView(Object object) {
                }
            };
        }
        return this.getViewHolder(this.layoutInflater.inflate(this.mIds[viewType], parent, false), viewType);
    }

    public void onBindViewHolder(XViewHolder<T> holder, int position) {
        if (this.isNeedHeaderLoadMore && position == 0) {
            holder.bindView(null);
        } else if (this.isNeedFooterLoadMore && position == this.getItemCount() - 1) {
            holder.bindView(null);
        } else if (this.isNeedHeaderLoadMore) {
            holder.bindView(this.mDatas.get(position - 1));
        } else {
            holder.bindView(this.mDatas.get(position));
        }
    }

    public int getItemCount() {
        if (this.isNeedFooterLoadMore && this.isNeedHeaderLoadMore) {
            return this.mDatas.size() + 2;
        }
        if (this.isNeedHeaderLoadMore || this.isNeedFooterLoadMore) {
            return this.mDatas.size() + 1;
        }
        return this.mDatas.size();
    }
}

