/*
 * Decompiled with CFR 0.152.
 */
package me.kaneki.xchatmessageview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.List;
import me.kaneki.xchatmessageview.R;
import me.kaneki.xchatmessageview.XLinearLayoutManager;
import me.kaneki.xchatmessageview.XMessageAdapter;
import me.kaneki.xchatmessageview.listener.OnLoadMoreListener;

public class XChatMessageView<T>
extends ViewGroup {
    private Context context;
    private RecyclerView recyclerView;
    private XLinearLayoutManager linearLayoutManager;
    private XMessageAdapter messageAdpter;
    private OnLoadMoreListener onLoadMoreListener;
    private boolean isHeaderLoadMore = false;
    private boolean isFooterLoadMore = false;
    private int lastPosition = 0;
    private int lastOffset = 0;

    public XChatMessageView(Context context) {
        this(context, null);
    }

    public XChatMessageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public XChatMessageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.initView();
        this.initListener();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int measureWidth = this.measureWidth(widthMeasureSpec);
        int measureHeight = this.measureHeight(heightMeasureSpec);
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(measureWidth, measureHeight);
    }

    private int measureWidth(int pWidthMeasureSpec) {
        int result = 0;
        int widthMode = View.MeasureSpec.getMode((int)pWidthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)pWidthMeasureSpec);
        switch (widthMode) {
            case -2147483648: 
            case 0: 
            case 0x40000000: {
                result = widthSize;
            }
        }
        return result;
    }

    private int measureHeight(int pHeightMeasureSpec) {
        int result = 0;
        int heightMode = View.MeasureSpec.getMode((int)pHeightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)pHeightMeasureSpec);
        switch (heightMode) {
            case -2147483648: 
            case 0: 
            case 0x40000000: {
                result = heightSize;
            }
        }
        return result;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int mTotalHeight = 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            int measureHeight = childView.getMeasuredHeight();
            int measuredWidth = childView.getMeasuredWidth();
            childView.layout(l, mTotalHeight, measuredWidth, mTotalHeight + measureHeight);
            mTotalHeight += measureHeight;
        }
    }

    private void initView() {
        this.recyclerView = (RecyclerView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.x_recycler_view, (ViewGroup)this, false);
        this.recyclerView.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -1));
        this.linearLayoutManager = new XLinearLayoutManager(this.context);
        this.linearLayoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.linearLayoutManager);
        this.addView((View)this.recyclerView);
    }

    private void initListener() {
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                int firstPos = XChatMessageView.this.linearLayoutManager.findFirstVisibleItemPosition();
                int lastPos = XChatMessageView.this.linearLayoutManager.findLastVisibleItemPosition();
                if (XChatMessageView.this.messageAdpter.isNeedFooterLoadMore() || XChatMessageView.this.messageAdpter.isNeedHeaderLoadMore()) {
                    if (firstPos == 0 && !XChatMessageView.this.isHeaderLoadMore) {
                        XChatMessageView.this.isHeaderLoadMore = true;
                        XChatMessageView.this.onLoadMoreListener.onHeaderLoadMore();
                    } else if (lastPos == XChatMessageView.this.messageAdpter.getItemCount() - 1 && !XChatMessageView.this.isFooterLoadMore) {
                        XChatMessageView.this.isFooterLoadMore = true;
                        XChatMessageView.this.onLoadMoreListener.onFooterLoadMore();
                    }
                }
            }
        });
    }

    private void saveCurrent() {
        int firstPos = this.linearLayoutManager.findFirstVisibleItemPosition();
        View currentView = this.linearLayoutManager.getChildAt(firstPos);
        if (currentView != null) {
            this.lastOffset = currentView.getTop();
            this.lastPosition = this.linearLayoutManager.getPosition(currentView);
        }
    }

    private void resumeSave(int changeSize) {
        this.linearLayoutManager.scrollToPositionWithOffset(this.lastPosition + changeSize, this.lastOffset);
    }

    public void setMessageAdapter(XMessageAdapter messageAdapter) {
        this.messageAdpter = messageAdapter;
        this.recyclerView.setAdapter((RecyclerView.Adapter)messageAdapter);
    }

    public void setOnLoadMoreListener(OnLoadMoreListener onLoadMoreListener) {
        this.onLoadMoreListener = onLoadMoreListener;
    }

    public RecyclerView.Adapter getMessageAdpter() {
        return this.messageAdpter;
    }

    public void setIsNeedHeaderLoadMore(boolean isNeedHeaderLoadMore) {
        this.messageAdpter.setNeedHeaderLoadMore(isNeedHeaderLoadMore);
    }

    public void setIsNeedFooterLoadMore(boolean isNeedFooterLoadMore) {
        this.messageAdpter.setNeedFooterLoadMore(isNeedFooterLoadMore);
    }

    public int getMessageItemPosition(View view) {
        return this.linearLayoutManager == null ? -1 : this.linearLayoutManager.getPosition(view);
    }

    public void addMessageAtLast(T t) {
        this.messageAdpter.addMessageAtLast(t);
        this.scrollToBottom();
    }

    public void addMoreMessageAtLast(List<T> tList) {
        this.messageAdpter.addMoreMessageAtLast(tList);
        this.isFooterLoadMore = false;
    }

    public void addMoreMessageAtFirst(List<T> tList) {
        this.messageAdpter.addMoreMessageAtFirst(tList);
        this.isHeaderLoadMore = false;
        this.resumeSave(tList.size());
    }

    public void reomveMessage(View view) {
        int position = this.linearLayoutManager.getPosition(view);
        this.messageAdpter.removeMessageAtPosition(position);
    }

    public void removeAllMessage() {
        this.messageAdpter.removeAllMessage();
    }

    public void scrollToBottom() {
        this.recyclerView.scrollToPosition(this.messageAdpter.getItemCount() - 1);
    }

    public void saveCurrentStatus() {
        this.saveCurrent();
    }

    public void resumeSaveStatus() {
        this.resumeSave(0);
    }
}

