/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.wedges;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.util.Log;
import android.view.View;
import androidx.annotation.LayoutRes;
import androidx.recyclerview.widget.RecyclerView;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import me.jfenn.attribouter.data.github.GitHubData;
import me.jfenn.attribouter.interfaces.Mergeable;
import org.xmlpull.v1.XmlPullParserException;

public abstract class Wedge<T extends ViewHolder>
implements GitHubData.OnInitListener {
    private int layoutRes;
    private List<Wedge> children;
    private List<GitHubData> requests;
    private OnRequestListener listener;

    public Wedge(@LayoutRes int layoutRes) {
        this.layoutRes = layoutRes;
        this.requests = new ArrayList<GitHubData>();
        this.children = new ArrayList<Wedge>();
    }

    protected void addChildren(XmlResourceParser parser) throws IOException, XmlPullParserException {
        while (parser.next() != 3 || !parser.getName().equals(this.getClass().getName())) {
            if (parser.getEventType() != 2) continue;
            try {
                Class<?> classy = Class.forName(parser.getName());
                Constructor<?> constructor = classy.getConstructor(XmlResourceParser.class);
                this.addChild((Wedge)constructor.newInstance(parser));
            }
            catch (ClassNotFoundException e) {
                Log.e((String)"Attribouter", (String)("Class name \"" + parser.getName() + "\" not found - you should probably check your configuration file for typos."));
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                Log.e((String)"Attribouter", (String)("Class \"" + parser.getName() + "\" definitely exists, but doesn't have the correct constructor. Check that you have defined one with a single argument - 'android.content.res.XmlResourceParser'"));
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                Log.e((String)"Attribouter", (String)("Class \"" + parser.getName() + "\" has been instantiated correctly, but it must extend 'me.jfenn.attribouter.data.info.InfoData' to be worthy of the great RecyclerView adapter."));
                e.printStackTrace();
            }
        }
    }

    Wedge addChild(Wedge child) {
        return this.addChild(this.children.size(), child);
    }

    Wedge addChild(int index, Wedge child) {
        if (!this.children.contains(child)) {
            this.children.add(index, child);
        } else {
            Wedge merger = this.children.get(this.children.indexOf(child));
            if (merger instanceof Mergeable) {
                ((Mergeable)((Object)merger)).merge(child);
                return merger;
            }
            this.children.add(index, child);
        }
        if (this.listener != null) {
            child.setOnRequestListener(this.listener);
        }
        return child;
    }

    public List<Wedge> getChildren() {
        return this.children;
    }

    public <X extends Wedge> List<X> getChildren(Class<X> type) {
        ArrayList<Wedge> children = new ArrayList<Wedge>();
        for (Wedge info : this.getChildren()) {
            if (!type.isInstance(info)) continue;
            children.add(info);
        }
        return children;
    }

    protected void addRequest(GitHubData request) {
        request.addOnInitListener(this);
        this.requests.add(request);
        if (this.listener != null) {
            this.listener.onRequest(this, request);
        }
    }

    public final void setOnRequestListener(OnRequestListener listener) {
        this.listener = listener;
        if (listener != null) {
            for (GitHubData request : this.requests) {
                listener.onRequest(this, request);
            }
        }
        for (Wedge child : this.children) {
            child.setOnRequestListener(listener);
        }
    }

    public final List<GitHubData> getRequests() {
        return this.requests;
    }

    public final boolean hasRequest(GitHubData request) {
        return this.requests.contains(request);
    }

    public final int getLayoutRes() {
        return this.layoutRes;
    }

    public abstract T getViewHolder(View var1);

    public abstract void bind(Context var1, T var2);

    @Override
    public void onInit(GitHubData data) {
    }

    @Override
    public void onFailure(GitHubData data) {
    }

    public static interface OnRequestListener {
        public void onRequest(Wedge var1, GitHubData var2);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        public ViewHolder(View v) {
            super(v);
        }
    }
}

