/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.wedges;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.io.IOException;
import java.util.ArrayList;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.adapters.InfoAdapter;
import me.jfenn.attribouter.data.github.ContributorsData;
import me.jfenn.attribouter.data.github.GitHubData;
import me.jfenn.attribouter.data.github.UserData;
import me.jfenn.attribouter.dialogs.OverflowDialog;
import me.jfenn.attribouter.dialogs.UserDialog;
import me.jfenn.attribouter.interfaces.Mergeable;
import me.jfenn.attribouter.utils.ResourceUtils;
import me.jfenn.attribouter.utils.UrlClickListener;
import me.jfenn.attribouter.wedges.ContributorWedge;
import me.jfenn.attribouter.wedges.Wedge;
import org.xmlpull.v1.XmlPullParserException;

public class ContributorsWedge
extends Wedge<ViewHolder> {
    @Nullable
    private String repo;
    @Nullable
    private String contributorsTitle;
    private int overflow;

    public ContributorsWedge(XmlResourceParser parser) throws XmlPullParserException, IOException {
        super(R.layout.item_attribouter_contributors);
        this.repo = parser.getAttributeValue(null, "repo");
        this.contributorsTitle = parser.getAttributeValue(null, "title");
        if (this.contributorsTitle == null) {
            this.contributorsTitle = "@string/title_attribouter_contributors";
        }
        boolean showDefaults = parser.getAttributeBooleanValue(null, "showDefaults", true);
        this.overflow = parser.getAttributeIntValue(null, "overflow", -1);
        this.addChildren(parser);
        if (showDefaults) {
            ContributorWedge me = new ContributorWedge("TheAndroidMaster", "James Fenn", "https://avatars1.githubusercontent.com/u/13000407", "^Library Developer", null, "Android developer and co-founder of Double Dot Labs. Writes Java, C, and HTML. PHP confuses me.", "https://jfenn.me/", "dev@jfenn.me");
            this.addChild(me);
            this.addRequest(new ContributorsData("TheAndroidMaster/Attribouter"));
        }
        this.addRequest(new ContributorsData(this.repo));
    }

    @Override
    public void onInit(GitHubData data) {
        if (data instanceof ContributorsData) {
            if (((ContributorsData)data).contributors != null) {
                for (ContributorsData.ContributorData contributor : ((ContributorsData)data).contributors) {
                    if (contributor.login == null) continue;
                    Wedge info = this.addChild(new ContributorWedge(contributor.login, null, contributor.avatar_url, this.repo != null && this.repo.startsWith(contributor.login) ? "Owner" : "Contributor", null, null, null, null));
                    if (!(info instanceof Mergeable) || ((Mergeable)((Object)info)).hasAll()) continue;
                    this.addRequest(new UserData(contributor.login));
                }
            }
        } else if (data instanceof UserData) {
            UserData user = (UserData)data;
            this.addChild(0, new ContributorWedge(user.login, user.name, user.avatar_url, this.repo != null && this.repo.startsWith(user.login) ? "Owner" : "Contributor", null, user.bio, user.blog, user.email));
        }
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    @Override
    public void bind(Context context, ViewHolder viewHolder) {
        if (this.overflow == 0) {
            viewHolder.titleView.setVisibility(8);
            viewHolder.recycler.setVisibility(8);
            viewHolder.expand.setVisibility(8);
            viewHolder.topThreeView.setVisibility(8);
            viewHolder.overflow.setVisibility(0);
            viewHolder.overflow.setText((CharSequence)ResourceUtils.getString(context, this.contributorsTitle));
            viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    new OverflowDialog(v.getContext(), ContributorsWedge.this.contributorsTitle, ContributorsWedge.this.getChildren()).show();
                }
            });
            return;
        }
        viewHolder.titleView.setVisibility(0);
        viewHolder.recycler.setVisibility(0);
        viewHolder.expand.setVisibility(0);
        viewHolder.overflow.setVisibility(8);
        viewHolder.itemView.setOnClickListener(null);
        if (this.contributorsTitle != null) {
            viewHolder.titleView.setText((CharSequence)ResourceUtils.getString(context, this.contributorsTitle));
        }
        ContributorWedge first = null;
        ContributorWedge second = null;
        ContributorWedge third = null;
        ArrayList<Wedge> remainingContributors = new ArrayList<Wedge>();
        int hiddenContributors = 0;
        for (ContributorWedge contributor : this.getChildren(ContributorWedge.class)) {
            if (contributor.isHidden()) {
                ++hiddenContributors;
                continue;
            }
            if (contributor.position != null) {
                if (first == null && contributor.position == 1) {
                    first = contributor;
                    continue;
                }
                if (second == null && contributor.position == 2) {
                    second = contributor;
                    continue;
                }
                if (third == null && contributor.position == 3) {
                    third = contributor;
                    continue;
                }
            }
            if (remainingContributors.size() >= this.overflow && this.overflow != -1) continue;
            remainingContributors.add(contributor);
        }
        if (first != null && second != null && third != null) {
            viewHolder.topThreeView.setVisibility(0);
            viewHolder.firstNameView.setText((CharSequence)ResourceUtils.getString(context, first.getName()));
            ResourceUtils.setImage(context, first.avatarUrl, viewHolder.firstImageView);
            if (first.task != null) {
                viewHolder.firstTaskView.setVisibility(0);
                viewHolder.firstTaskView.setText((CharSequence)ResourceUtils.getString(context, first.task));
            } else {
                viewHolder.firstTaskView.setVisibility(8);
            }
            viewHolder.firstView.setTag((Object)first);
            if (ResourceUtils.getString(context, first.bio) != null) {
                viewHolder.firstView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        new UserDialog(view.getContext(), (ContributorWedge)view.getTag()).show();
                    }
                });
            } else if (ResourceUtils.getString(context, first.blog) != null) {
                viewHolder.firstView.setOnClickListener((View.OnClickListener)new UrlClickListener(ResourceUtils.getString(context, first.blog)));
            } else if (first.login != null) {
                viewHolder.firstView.setOnClickListener((View.OnClickListener)new UrlClickListener("https://github.com/" + first.login));
            } else {
                viewHolder.firstView.setOnClickListener(null);
            }
            viewHolder.secondNameView.setText((CharSequence)ResourceUtils.getString(context, second.getName()));
            ResourceUtils.setImage(context, second.avatarUrl, viewHolder.secondImageView);
            if (second.task != null) {
                viewHolder.secondTaskView.setVisibility(0);
                viewHolder.secondTaskView.setText((CharSequence)ResourceUtils.getString(context, second.task));
            } else {
                viewHolder.secondTaskView.setVisibility(8);
            }
            viewHolder.secondView.setTag((Object)second);
            if (ResourceUtils.getString(context, second.bio) != null) {
                viewHolder.secondView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        new UserDialog(view.getContext(), (ContributorWedge)view.getTag()).show();
                    }
                });
            } else if (ResourceUtils.getString(context, second.blog) != null) {
                viewHolder.secondView.setOnClickListener((View.OnClickListener)new UrlClickListener(ResourceUtils.getString(context, second.blog)));
            } else if (second.login != null) {
                viewHolder.secondView.setOnClickListener((View.OnClickListener)new UrlClickListener("https://github.com/" + second.login));
            } else {
                viewHolder.secondView.setOnClickListener(null);
            }
            viewHolder.thirdNameView.setText((CharSequence)ResourceUtils.getString(context, third.getName()));
            ResourceUtils.setImage(context, third.avatarUrl, viewHolder.thirdImageView);
            if (third.task != null) {
                viewHolder.thirdTaskView.setVisibility(0);
                viewHolder.thirdTaskView.setText((CharSequence)ResourceUtils.getString(context, third.task));
            } else {
                viewHolder.thirdTaskView.setVisibility(8);
            }
            viewHolder.thirdView.setTag((Object)third);
            if (ResourceUtils.getString(context, third.bio) != null) {
                viewHolder.thirdView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        new UserDialog(view.getContext(), (ContributorWedge)view.getTag()).show();
                    }
                });
            } else if (ResourceUtils.getString(context, third.blog) != null) {
                viewHolder.thirdView.setOnClickListener((View.OnClickListener)new UrlClickListener(ResourceUtils.getString(context, third.blog)));
            } else if (third.login != null) {
                viewHolder.thirdView.setOnClickListener((View.OnClickListener)new UrlClickListener("https://github.com/" + third.login));
            } else {
                viewHolder.thirdView.setOnClickListener(null);
            }
        } else {
            viewHolder.topThreeView.setVisibility(8);
            if (third != null) {
                remainingContributors.add(0, third);
            }
            if (second != null) {
                remainingContributors.add(0, second);
            }
            if (first != null) {
                remainingContributors.add(0, first);
            }
        }
        if (remainingContributors.size() > 0) {
            viewHolder.recycler.setVisibility(0);
            viewHolder.recycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
            viewHolder.recycler.setAdapter((RecyclerView.Adapter)new InfoAdapter(remainingContributors));
        } else {
            viewHolder.recycler.setVisibility(8);
        }
        if (remainingContributors.size() + (first != null && second != null && third != null ? 3 : 0) < this.getChildren().size() - hiddenContributors) {
            viewHolder.expand.setVisibility(0);
            viewHolder.expand.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ArrayList<Wedge> overflowList = new ArrayList<Wedge>();
                    for (ContributorWedge contributor : ContributorsWedge.this.getChildren(ContributorWedge.class)) {
                        if (contributor.isHidden()) continue;
                        overflowList.add(contributor);
                    }
                    new OverflowDialog(v.getContext(), ContributorsWedge.this.contributorsTitle, overflowList).show();
                }
            });
        } else {
            viewHolder.expand.setVisibility(8);
        }
    }

    protected class ViewHolder
    extends Wedge.ViewHolder {
        protected TextView titleView;
        protected View topThreeView;
        protected View firstView;
        protected ImageView firstImageView;
        protected TextView firstNameView;
        protected TextView firstTaskView;
        protected View secondView;
        protected ImageView secondImageView;
        protected TextView secondNameView;
        protected TextView secondTaskView;
        protected View thirdView;
        protected ImageView thirdImageView;
        protected TextView thirdNameView;
        protected TextView thirdTaskView;
        protected View expand;
        protected TextView overflow;
        protected RecyclerView recycler;

        protected ViewHolder(View v) {
            super(v);
            this.titleView = (TextView)v.findViewById(R.id.contributorsTitle);
            this.topThreeView = v.findViewById(R.id.topThree);
            this.firstView = v.findViewById(R.id.first);
            this.firstImageView = (ImageView)v.findViewById(R.id.firstImage);
            this.firstNameView = (TextView)v.findViewById(R.id.firstName);
            this.firstTaskView = (TextView)v.findViewById(R.id.firstTask);
            this.secondView = v.findViewById(R.id.second);
            this.secondImageView = (ImageView)v.findViewById(R.id.secondImage);
            this.secondNameView = (TextView)v.findViewById(R.id.secondName);
            this.secondTaskView = (TextView)v.findViewById(R.id.secondTask);
            this.thirdView = v.findViewById(R.id.third);
            this.thirdImageView = (ImageView)v.findViewById(R.id.thirdImage);
            this.thirdNameView = (TextView)v.findViewById(R.id.thirdName);
            this.thirdTaskView = (TextView)v.findViewById(R.id.thirdTask);
            this.recycler = (RecyclerView)v.findViewById(R.id.recycler);
            this.expand = v.findViewById(R.id.expand);
            this.overflow = (TextView)v.findViewById(R.id.overflow);
        }
    }
}

