/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.dialogs;

import android.content.Context;
import android.os.Bundle;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatDialog;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.flexbox.FlexboxLayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.adapters.InfoAdapter;
import me.jfenn.attribouter.utils.ResourceUtils;
import me.jfenn.attribouter.wedges.ContributorWedge;
import me.jfenn.attribouter.wedges.Wedge;
import me.jfenn.attribouter.wedges.link.LinkWedge;

public class UserDialog
extends AppCompatDialog {
    private ContributorWedge contributor;

    public UserDialog(Context context, ContributorWedge contributor) {
        super(context, ResourceUtils.getThemeResourceAttribute(context, R.styleable.AttribouterTheme_personDialogTheme, R.style.AttribouterTheme_Dialog));
        this.contributor = contributor;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dialog_attribouter_user);
        TextView nameView = (TextView)this.findViewById(R.id.name);
        TextView taskView = (TextView)this.findViewById(R.id.task);
        ImageView imageView = (ImageView)this.findViewById(R.id.image);
        TextView bioView = (TextView)this.findViewById(R.id.description);
        RecyclerView recycler = (RecyclerView)this.findViewById(R.id.links);
        nameView.setText((CharSequence)ResourceUtils.getString(this.getContext(), this.contributor.getName()));
        taskView.setText((CharSequence)ResourceUtils.getString(this.getContext(), this.contributor.task));
        String url = ResourceUtils.getString(this.getContext(), this.contributor.avatarUrl);
        if (url != null) {
            ResourceUtils.setImage(this.getContext(), this.contributor.avatarUrl, imageView);
        } else {
            imageView.setVisibility(8);
        }
        bioView.setText((CharSequence)ResourceUtils.getString(this.getContext(), this.contributor.bio));
        List<LinkWedge> links = this.contributor.getChildren(LinkWedge.class);
        if (links.size() > 0) {
            Collections.sort(links, new LinkWedge.Comparator(this.getContext()));
            ArrayList<Wedge> linksList = new ArrayList<Wedge>();
            for (LinkWedge link : links) {
                if (link.isHidden()) continue;
                linksList.add(link);
            }
            recycler.setVisibility(0);
            FlexboxLayoutManager layoutManager = new FlexboxLayoutManager(this.getContext());
            layoutManager.setFlexDirection(0);
            layoutManager.setJustifyContent(0);
            recycler.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            recycler.setAdapter((RecyclerView.Adapter)new InfoAdapter(linksList));
        } else {
            recycler.setVisibility(8);
        }
    }
}

