/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.dialogs;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatDialog;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.utils.ResourceUtils;
import me.jfenn.attribouter.utils.UrlClickListener;
import me.jfenn.attribouter.wedges.LicenseWedge;

public class LicenseDialog
extends AppCompatDialog {
    private LicenseWedge license;

    public LicenseDialog(Context context, LicenseWedge license) {
        super(context, ResourceUtils.getThemeResourceAttribute(context, R.styleable.AttribouterTheme_licenseDialogTheme, R.style.AttribouterTheme_Dialog));
        this.license = license;
    }

    protected void onCreate(Bundle savedInstanceState) {
        String body;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dialog_attribouter_license);
        TextView nameView = (TextView)this.findViewById(R.id.name);
        TextView descriptionView = (TextView)this.findViewById(R.id.description);
        View infoContainerView = this.findViewById(R.id.infoContainer);
        View permissionsView = this.findViewById(R.id.permissions);
        TextView permissionsTextView = (TextView)this.findViewById(R.id.permissionsText);
        View conditionsView = this.findViewById(R.id.conditions);
        TextView conditionsTextView = (TextView)this.findViewById(R.id.conditionsText);
        View limitationsView = this.findViewById(R.id.limitations);
        TextView limitationsTextView = (TextView)this.findViewById(R.id.limitationsText);
        View bodyContainerView = this.findViewById(R.id.bodyContainer);
        TextView bodyView = (TextView)this.findViewById(R.id.body);
        View moreInfoButton = this.findViewById(R.id.moreInfo);
        nameView.setText((CharSequence)ResourceUtils.getString(this.getContext(), this.license.licenseName));
        if (this.license.licenseDescription != null) {
            descriptionView.setText((CharSequence)this.license.licenseDescription);
        } else {
            descriptionView.setVisibility(8);
        }
        String permissions = this.license.getLicensePermissions();
        if (permissions != null) {
            permissionsTextView.setText((CharSequence)permissions);
        } else {
            permissionsView.setVisibility(8);
        }
        String conditions = this.license.getLicenseConditions();
        if (conditions != null) {
            conditionsTextView.setText((CharSequence)conditions);
        } else {
            conditionsView.setVisibility(8);
        }
        String limitations = this.license.getLicenseLimitations();
        if (limitations != null) {
            limitationsTextView.setText((CharSequence)limitations);
        } else {
            limitationsView.setVisibility(8);
        }
        if (permissions == null && conditions == null && limitations == null) {
            infoContainerView.setVisibility(8);
        }
        if ((body = ResourceUtils.getString(this.getContext(), this.license.licenseBody)) != null) {
            bodyView.setText((CharSequence)body);
        } else {
            bodyContainerView.setVisibility(8);
        }
        String moreInfo = ResourceUtils.getString(this.getContext(), this.license.licenseUrl);
        if (moreInfo != null) {
            moreInfoButton.setOnClickListener((View.OnClickListener)new UrlClickListener(moreInfo));
        } else {
            moreInfoButton.setVisibility(8);
        }
    }
}

