/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.wedges;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.view.View;
import android.widget.TextView;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.utils.ResourceUtils;
import me.jfenn.attribouter.wedges.Wedge;
import org.xmlpull.v1.XmlPullParserException;

public class TextWedge
extends Wedge {
    private String text;
    private boolean isCentered;

    public TextWedge(XmlResourceParser parser) throws XmlPullParserException {
        this(parser.getAttributeValue(null, "text"), parser.getAttributeBooleanValue(null, "centered", false));
    }

    public TextWedge(String text, boolean isCentered) {
        super(R.layout.item_attribouter_text);
        this.text = text;
        this.isCentered = isCentered;
    }

    public Wedge.ViewHolder getViewHolder(View v) {
        return new Wedge.ViewHolder(v);
    }

    public void bind(Context context, Wedge.ViewHolder viewHolder) {
        TextView textView = (TextView)viewHolder.itemView;
        textView.setMovementMethod((MovementMethod)new LinkMovementMethod());
        String text = ResourceUtils.getString(context, this.text);
        textView.setText((CharSequence)(Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)text, (int)0) : Html.fromHtml((String)text)));
        if (Build.VERSION.SDK_INT >= 17) {
            textView.setTextAlignment(this.isCentered ? 4 : 1);
        }
    }
}

