/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.views;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.media.ThumbnailUtils;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.graphics.drawable.RoundedBitmapDrawable;
import androidx.core.graphics.drawable.RoundedBitmapDrawableFactory;
import me.jfenn.attribouter.utils.ImageUtils;

public class CircleImageView
extends AppCompatImageView {
    Paint paint = new Paint();

    public CircleImageView(Context context) {
        super(context);
    }

    public CircleImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CircleImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void onDraw(Canvas canvas) {
        Bitmap image = ImageUtils.drawableToBitmap(this.getDrawable());
        if (image != null) {
            int size = Math.min(this.getWidth(), this.getHeight());
            image = ThumbnailUtils.extractThumbnail((Bitmap)image, (int)size, (int)size);
            RoundedBitmapDrawable roundedBitmapDrawable = RoundedBitmapDrawableFactory.create((Resources)this.getResources(), (Bitmap)image);
            roundedBitmapDrawable.setCornerRadius((float)(size / 2));
            roundedBitmapDrawable.setAntiAlias(true);
            canvas.drawBitmap(ImageUtils.drawableToBitmap((Drawable)roundedBitmapDrawable), 0.0f, 0.0f, this.paint);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int size = this.getMeasuredWidth();
        this.setMeasuredDimension(size, size);
    }
}

