/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;

public class ImageUtils {
    public static Bitmap drawableToBitmap(Drawable drawable2) {
        if (drawable2 == null) {
            drawable2 = new ColorDrawable(0);
        }
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        if (drawable2 instanceof VectorDrawableCompat || Build.VERSION.SDK_INT >= 21 && drawable2 instanceof VectorDrawable) {
            Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
            return bitmap;
        }
        int width = drawable2.getIntrinsicWidth();
        width = width > 0 ? width : 1;
        int height = drawable2.getIntrinsicHeight();
        height = height > 0 ? height : 1;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }
}

