/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.wedges;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.flexbox.FlexboxLayoutManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.adapters.InfoAdapter;
import me.jfenn.attribouter.data.github.GitHubData;
import me.jfenn.attribouter.data.github.RepositoryData;
import me.jfenn.attribouter.utils.ResourceUtils;
import me.jfenn.attribouter.wedges.Wedge;
import me.jfenn.attribouter.wedges.link.GitHubLinkWedge;
import me.jfenn.attribouter.wedges.link.LinkWedge;
import me.jfenn.attribouter.wedges.link.PlayStoreLinkWedge;
import me.jfenn.attribouter.wedges.link.WebsiteLinkWedge;
import org.xmlpull.v1.XmlPullParserException;

public class AppWedge
extends Wedge<ViewHolder> {
    @Nullable
    private String icon;
    @Nullable
    private String description;
    @Nullable
    private String playStoreUrl;
    @Nullable
    private String websiteUrl;
    @Nullable
    private String gitHubUrl;

    public AppWedge(XmlResourceParser parser) throws IOException, XmlPullParserException {
        super(R.layout.item_attribouter_app_info);
        this.icon = parser.getAttributeValue(null, "icon");
        this.description = parser.getAttributeValue(null, "description");
        this.playStoreUrl = parser.getAttributeValue(null, "playStoreUrl");
        this.websiteUrl = parser.getAttributeValue(null, "websiteUrl");
        this.gitHubUrl = parser.getAttributeValue(null, "gitHubUrl");
        String repo = parser.getAttributeValue(null, "repo");
        if (this.gitHubUrl == null && repo != null) {
            this.gitHubUrl = "https://github.com/" + repo;
        }
        if (repo != null || this.gitHubUrl != null) {
            this.addChild(new GitHubLinkWedge(this.gitHubUrl != null ? this.gitHubUrl : repo, 0, this.gitHubUrl != null));
        }
        if (this.websiteUrl != null) {
            this.addChild(new WebsiteLinkWedge(this.websiteUrl, 0));
        }
        this.addChild(new PlayStoreLinkWedge(this.playStoreUrl, 0));
        this.addChildren(parser);
        this.addRequest(new RepositoryData(repo));
    }

    @Override
    public void onInit(GitHubData data) {
        if (data instanceof RepositoryData) {
            RepositoryData repository = (RepositoryData)data;
            if (!(this.description != null && this.description.startsWith("^") || repository.description == null)) {
                this.description = repository.description;
            }
            ArrayList<LinkWedge> newLinks = new ArrayList<LinkWedge>();
            if (repository.html_url != null) {
                newLinks.add(new GitHubLinkWedge(repository.html_url, 0, true));
            }
            if (repository.homepage != null) {
                newLinks.add(repository.homepage.startsWith("https://play.google.com/") ? new PlayStoreLinkWedge(repository.homepage, 0) : new WebsiteLinkWedge(repository.homepage, 0));
            }
            for (LinkWedge link : newLinks) {
                this.addChild(link);
            }
        }
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    @Override
    public void bind(Context context, ViewHolder viewHolder) {
        ApplicationInfo info = context.getApplicationInfo();
        ResourceUtils.setImage(context, this.icon, info.icon, viewHolder.appIconView);
        viewHolder.nameTextView.setText(info.labelRes);
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(info.packageName, 0);
            viewHolder.versionTextView.setText((CharSequence)String.format(context.getString(R.string.title_attribouter_version), packageInfo.versionName));
            viewHolder.versionTextView.setVisibility(0);
        }
        catch (PackageManager.NameNotFoundException e) {
            viewHolder.versionTextView.setVisibility(8);
        }
        String actualDescription = ResourceUtils.getString(context, this.description);
        if (actualDescription != null) {
            viewHolder.descriptionTextView.setVisibility(0);
            viewHolder.descriptionTextView.setText((CharSequence)actualDescription);
        } else {
            viewHolder.descriptionTextView.setVisibility(8);
        }
        List<LinkWedge> links = this.getChildren(LinkWedge.class);
        if (links.size() > 0) {
            Collections.sort(links, new LinkWedge.Comparator(context));
            ArrayList<Wedge> linksList = new ArrayList<Wedge>();
            for (LinkWedge link : links) {
                if (link.isHidden()) continue;
                linksList.add(link);
            }
            viewHolder.links.setVisibility(0);
            FlexboxLayoutManager layoutManager = new FlexboxLayoutManager(context);
            layoutManager.setFlexDirection(0);
            layoutManager.setJustifyContent(2);
            viewHolder.links.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            viewHolder.links.setAdapter((RecyclerView.Adapter)new InfoAdapter(linksList));
        } else {
            viewHolder.links.setVisibility(8);
        }
    }

    protected static class ViewHolder
    extends Wedge.ViewHolder {
        protected ImageView appIconView;
        protected TextView nameTextView;
        protected TextView versionTextView;
        protected TextView descriptionTextView;
        protected RecyclerView links;

        protected ViewHolder(View v) {
            super(v);
            this.appIconView = (ImageView)v.findViewById(R.id.appIcon);
            this.nameTextView = (TextView)v.findViewById(R.id.appName);
            this.versionTextView = (TextView)v.findViewById(R.id.appVersion);
            this.descriptionTextView = (TextView)v.findViewById(R.id.description);
            this.links = (RecyclerView)v.findViewById(R.id.appLinks);
        }
    }
}

