/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.fragments;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.adapters.InfoAdapter;
import me.jfenn.attribouter.data.github.GitHubData;
import me.jfenn.attribouter.wedges.AppWedge;
import me.jfenn.attribouter.wedges.ContributorsWedge;
import me.jfenn.attribouter.wedges.LicensesWedge;
import me.jfenn.attribouter.wedges.TextWedge;
import me.jfenn.attribouter.wedges.TranslatorsWedge;
import me.jfenn.attribouter.wedges.Wedge;
import org.xmlpull.v1.XmlPullParserException;

public class AboutFragment
extends Fragment
implements GitHubData.OnInitListener,
Wedge.OnRequestListener {
    private RecyclerView recycler;
    private InfoAdapter adapter;
    private List<Wedge> infos;
    private List<GitHubData> requests;
    private String gitHubToken;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.recycler = (RecyclerView)inflater.inflate(R.layout.fragment_attribouter_about, container, false);
        this.infos = new ArrayList<Wedge>();
        Bundle args = this.getArguments();
        int fileRes = R.xml.attribouter;
        if (args != null) {
            this.gitHubToken = args.getString("me.jfenn.attribouter.EXTRA_GITHUB_OAUTH_TOKEN", null);
            fileRes = args.getInt("me.jfenn.attribouter.EXTRA_FILE_RES", fileRes);
        }
        XmlResourceParser parser = this.getResources().getXml(fileRes);
        try {
            while (parser.getEventType() != 1) {
                if (parser.getEventType() == 2) {
                    try {
                        Class<?> classy = Class.forName(parser.getName());
                        Constructor<?> constructor = classy.getConstructor(XmlResourceParser.class);
                        this.infos.add((Wedge)constructor.newInstance(parser));
                        parser.next();
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        Log.e((String)"Attribouter", (String)("Class name \"" + parser.getName() + "\" not found - you should probably check your configuration file for typos."));
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        Log.e((String)"Attribouter", (String)("Class \"" + parser.getName() + "\" definitely exists, but doesn't have the correct constructor. Check that you have defined one with a single argument - 'android.content.res.XmlResourceParser'"));
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (ClassCastException e) {
                        Log.e((String)"Attribouter", (String)("Class \"" + parser.getName() + "\" has been instantiated correctly, but it must extend 'me.jfenn.attribouter.data.info.InfoData' to be worthy of the great RecyclerView adapter."));
                        e.printStackTrace();
                    }
                    switch (parser.getName()) {
                        case "appInfo": {
                            this.infos.add(new AppWedge(parser));
                            break;
                        }
                        case "contributors": {
                            this.infos.add(new ContributorsWedge(parser));
                            break;
                        }
                        case "translators": {
                            this.infos.add(new TranslatorsWedge(parser));
                            break;
                        }
                        case "licenses": {
                            this.infos.add(new LicensesWedge(parser));
                            break;
                        }
                        case "text": {
                            this.infos.add(new TextWedge(parser));
                        }
                    }
                }
                parser.next();
            }
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
        }
        parser.close();
        this.adapter = new InfoAdapter(this.infos);
        this.recycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.recycler.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(this.recycler.getContext(), 1));
        this.recycler.setAdapter((RecyclerView.Adapter)this.adapter);
        this.requests = new ArrayList<GitHubData>();
        for (Wedge info : this.infos) {
            info.setOnRequestListener(this);
        }
        for (GitHubData request : this.requests) {
            request.addOnInitListener(this);
            request.startInit(this.getContext(), this.gitHubToken);
        }
        return this.recycler;
    }

    @Override
    public void onInit(GitHubData data) {
        for (int i = 0; i < this.infos.size(); ++i) {
            if (this.infos.get(i).hasRequest(data)) {
                this.adapter.notifyItemChanged(i);
                continue;
            }
            this.notifyChildren(i, this.infos.get(i).getChildren(), data);
        }
        this.recycler.smoothScrollToPosition(0);
    }

    private void notifyChildren(int index, List<Wedge> children, GitHubData data) {
        if (children.size() < 1) {
            return;
        }
        for (Wedge child : children) {
            if (child.hasRequest(data)) {
                this.adapter.notifyItemChanged(index);
                return;
            }
            this.notifyChildren(index, child.getChildren(), data);
        }
    }

    @Override
    public void onFailure(GitHubData data) {
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.requests != null) {
            for (GitHubData request : this.requests) {
                request.interruptThread();
            }
        }
    }

    @Override
    public void onRequest(Wedge info, GitHubData request) {
        if (!this.requests.contains(request)) {
            this.requests.add(request);
            request.addOnInitListener(this);
            Context context = this.getContext();
            if (context != null) {
                request.startInit(context, this.gitHubToken);
            }
        } else {
            int i = this.requests.indexOf(request);
            GitHubData activeRequest = this.requests.get(i).merge(request);
            if (activeRequest.isInitialized()) {
                info.onInit(activeRequest);
            }
        }
    }
}

