/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.wedges;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.adapters.InfoAdapter;
import me.jfenn.attribouter.data.github.ContributorsData;
import me.jfenn.attribouter.data.github.GitHubData;
import me.jfenn.attribouter.data.github.UserData;
import me.jfenn.attribouter.dialogs.OverflowDialog;
import me.jfenn.attribouter.interfaces.Mergeable;
import me.jfenn.attribouter.utils.ResourceUtils;
import me.jfenn.attribouter.wedges.HeaderWedge;
import me.jfenn.attribouter.wedges.TranslatorWedge;
import me.jfenn.attribouter.wedges.Wedge;
import org.xmlpull.v1.XmlPullParserException;

public class TranslatorsWedge
extends Wedge<ViewHolder> {
    @Nullable
    private String translatorsTitle;
    private List<Wedge> sortedTranslators;
    private int overflow;

    public TranslatorsWedge(XmlResourceParser parser) throws XmlPullParserException, IOException {
        super(R.layout.item_attribouter_translators);
        this.translatorsTitle = parser.getAttributeValue(null, "title");
        if (this.translatorsTitle == null) {
            this.translatorsTitle = "@string/title_attribouter_translators";
        }
        this.overflow = parser.getAttributeIntValue(null, "overflow", -1);
        this.addChildren(parser);
    }

    @Override
    public void onInit(GitHubData data) {
        if (data instanceof ContributorsData) {
            if (((ContributorsData)data).contributors != null) {
                for (ContributorsData.ContributorData contributor : ((ContributorsData)data).contributors) {
                    Wedge child;
                    if (contributor.login == null || !((child = this.addChild(new TranslatorWedge(contributor.login, null, contributor.avatar_url, null, null, null))) instanceof Mergeable) || ((Mergeable)((Object)child)).hasAll()) continue;
                    this.addRequest(new UserData(contributor.login));
                }
            }
        } else if (data instanceof UserData) {
            UserData user = (UserData)data;
            this.addChild(0, new TranslatorWedge(user.login, user.name, user.avatar_url, null, user.blog, user.email));
        }
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    @Override
    public void bind(Context context, ViewHolder viewHolder) {
        int remaining = this.overflow;
        ArrayList<Wedge> sortedList = new ArrayList<Wedge>();
        this.sortedTranslators = new ArrayList<Wedge>();
        for (String language : Locale.getISOLanguages()) {
            boolean isHeader = false;
            for (TranslatorWedge translator : this.getChildren(TranslatorWedge.class)) {
                if (translator.locales == null || translator.locales.length() < 1) continue;
                boolean isLocale = false;
                for (String locale : translator.locales.split(",")) {
                    if (!language.equals(locale)) continue;
                    isLocale = true;
                    break;
                }
                if (!isLocale) continue;
                if (!isHeader) {
                    HeaderWedge header = new HeaderWedge(new Locale(language).getDisplayLanguage());
                    this.sortedTranslators.add(header);
                    if (remaining != 0) {
                        sortedList.add(header);
                    }
                    isHeader = true;
                }
                this.sortedTranslators.add(translator);
                if (remaining == 0) continue;
                sortedList.add(translator);
                --remaining;
            }
        }
        if (this.overflow == 0) {
            viewHolder.titleView.setVisibility(8);
            viewHolder.recycler.setVisibility(8);
            viewHolder.expand.setVisibility(8);
            viewHolder.overflow.setVisibility(0);
            viewHolder.overflow.setText((CharSequence)ResourceUtils.getString(context, this.translatorsTitle));
            viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    new OverflowDialog(v.getContext(), TranslatorsWedge.this.translatorsTitle, TranslatorsWedge.this.sortedTranslators).show();
                }
            });
            return;
        }
        viewHolder.titleView.setVisibility(0);
        viewHolder.recycler.setVisibility(0);
        viewHolder.expand.setVisibility(0);
        viewHolder.overflow.setVisibility(8);
        viewHolder.itemView.setOnClickListener(null);
        if (this.translatorsTitle != null) {
            viewHolder.titleView.setText((CharSequence)ResourceUtils.getString(context, this.translatorsTitle));
        }
        viewHolder.recycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        viewHolder.recycler.setAdapter((RecyclerView.Adapter)new InfoAdapter(sortedList));
        if (this.sortedTranslators.size() > sortedList.size()) {
            viewHolder.expand.setVisibility(0);
            viewHolder.expand.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    new OverflowDialog(v.getContext(), TranslatorsWedge.this.translatorsTitle, TranslatorsWedge.this.sortedTranslators).show();
                }
            });
        } else {
            viewHolder.expand.setVisibility(8);
        }
    }

    class ViewHolder
    extends Wedge.ViewHolder {
        private TextView titleView;
        private RecyclerView recycler;
        private View expand;
        private TextView overflow;

        ViewHolder(View v) {
            super(v);
            this.titleView = (TextView)v.findViewById(R.id.contributorsTitle);
            this.recycler = (RecyclerView)v.findViewById(R.id.recycler);
            this.expand = v.findViewById(R.id.expand);
            this.overflow = (TextView)v.findViewById(R.id.overflow);
        }
    }
}

