/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.wedges;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import com.google.android.flexbox.FlexboxLayoutManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.adapters.InfoAdapter;
import me.jfenn.attribouter.data.github.GitHubData;
import me.jfenn.attribouter.data.github.LicenseData;
import me.jfenn.attribouter.data.github.RepositoryData;
import me.jfenn.attribouter.interfaces.Mergeable;
import me.jfenn.attribouter.utils.ResourceUtils;
import me.jfenn.attribouter.wedges.Wedge;
import me.jfenn.attribouter.wedges.link.GitHubLinkWedge;
import me.jfenn.attribouter.wedges.link.LicenseLinkWedge;
import me.jfenn.attribouter.wedges.link.LinkWedge;
import me.jfenn.attribouter.wedges.link.WebsiteLinkWedge;
import org.xmlpull.v1.XmlPullParserException;

public class LicenseWedge
extends Wedge<ViewHolder>
implements Mergeable<LicenseWedge> {
    @Nullable
    String token;
    @Nullable
    String repo;
    @Nullable
    String title;
    @Nullable
    String description;
    @Nullable
    public String licenseName;
    @Nullable
    String websiteUrl;
    @Nullable
    String gitHubUrl;
    @Nullable
    public String licenseUrl;
    @Nullable
    String[] licensePermissions;
    @Nullable
    String[] licenseConditions;
    @Nullable
    String[] licenseLimitations;
    @Nullable
    public String licenseDescription;
    @Nullable
    public String licenseBody;
    @Nullable
    String licenseKey;

    public LicenseWedge(XmlResourceParser parser) throws IOException, XmlPullParserException {
        this(parser.getAttributeValue(null, "repo"), parser.getAttributeValue(null, "title"), parser.getAttributeValue(null, "description"), parser.getAttributeValue(null, "licenseName"), parser.getAttributeValue(null, "website"), parser.getAttributeValue(null, "gitHubUrl"), parser.getAttributeValue(null, "licenseUrl"), null, null, null, null, parser.getAttributeValue(null, "licenseBody"), parser.getAttributeValue(null, "license"));
        this.addChildren(parser);
    }

    public LicenseWedge(@Nullable String repo, @Nullable String title, @Nullable String description, @Nullable String licenseName, @Nullable String websiteUrl, @Nullable String gitHubUrl, @Nullable String licenseUrl, @Nullable String[] licensePermissions, @Nullable String[] licenseConditions, @Nullable String[] licenseLimitations, @Nullable String licenseDescription, @Nullable String licenseBody, @Nullable String licenseKey) {
        super(R.layout.item_attribouter_license);
        this.repo = repo;
        this.title = title;
        this.description = description;
        this.licenseName = licenseName;
        this.websiteUrl = websiteUrl;
        this.gitHubUrl = gitHubUrl;
        this.licenseUrl = licenseUrl;
        this.licensePermissions = licensePermissions;
        this.licenseConditions = licenseConditions;
        this.licenseLimitations = licenseLimitations;
        this.licenseDescription = licenseDescription;
        this.licenseBody = licenseBody;
        this.licenseKey = licenseKey;
        this.token = repo != null ? repo : title;
        if (websiteUrl != null && !websiteUrl.isEmpty()) {
            this.addChild(new WebsiteLinkWedge(websiteUrl, 2));
        }
        if (repo != null) {
            this.addChild(new GitHubLinkWedge(repo, 1));
        }
        if (licenseBody != null || licenseUrl != null) {
            this.addChild(new LicenseLinkWedge(this, 0));
        }
        if (repo != null && !this.hasAllGeneric()) {
            this.addRequest(new RepositoryData(repo));
        }
        if (!(licenseKey == null || repo == null && title == null || this.hasAllLicense())) {
            LicenseData request = new LicenseData(licenseKey);
            request.addTag(this.token);
            this.addRequest(request);
        }
    }

    @Override
    public void onInit(GitHubData data) {
        if (data instanceof RepositoryData) {
            RepositoryData repo = (RepositoryData)data;
            this.merge(new LicenseWedge(null, null, repo.description, repo.license != null ? repo.license.name : null, repo.homepage, null, null, null, null, null, null, null, null));
            if (repo.license != null && repo.license.key != null && !this.hasAllLicense()) {
                this.addRequest(new LicenseData(repo.license.key));
            }
        } else if (data instanceof LicenseData) {
            LicenseData license = (LicenseData)data;
            this.merge(new LicenseWedge(null, null, null, license.name, null, null, license.html_url, license.permissions, license.conditions, license.limitations, license.description, license.body, license.key));
        }
    }

    public String getName() {
        if (this.title != null) {
            return this.title;
        }
        if (this.repo != null) {
            String name = this.repo;
            if (name.contains("/")) {
                String[] names = name.split("/");
                name = names.length > 1 && names[1].length() > 0 ? names[1] : names[0];
            }
            name = name.replace('-', ' ').replace('_', ' ').replaceAll("([a-z])([A-Z])", "$1 $2").replaceAll("([A-Z])([A-Z][a-z])", "$1 $2").trim();
            StringBuffer nameBuffer = new StringBuffer();
            Pattern pattern = Pattern.compile("\\b(\\w)");
            Matcher matcher = pattern.matcher(name);
            while (matcher.find()) {
                matcher.appendReplacement(nameBuffer, matcher.group(1).toUpperCase());
            }
            return matcher.appendTail(nameBuffer).toString();
        }
        return null;
    }

    public String getLicensePermissions() {
        if (this.licensePermissions == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String permission : this.licensePermissions) {
            if (permission.length() <= 1) continue;
            builder.append(String.valueOf(permission.charAt(0)).toUpperCase()).append(permission.replace('-', ' ').substring(1)).append("\n");
        }
        return builder.substring(0, builder.length() - 1);
    }

    public String getLicenseConditions() {
        if (this.licenseConditions == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String condition : this.licenseConditions) {
            if (condition.length() <= 1) continue;
            builder.append(String.valueOf(condition.charAt(0)).toUpperCase()).append(condition.replace('-', ' ').substring(1)).append("\n");
        }
        return builder.substring(0, builder.length() - 1);
    }

    public String getLicenseLimitations() {
        if (this.licenseLimitations == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String limitation : this.licenseLimitations) {
            if (limitation.length() <= 1) continue;
            builder.append(String.valueOf(limitation.charAt(0)).toUpperCase()).append(limitation.replace('-', ' ').substring(1)).append("\n");
        }
        return builder.substring(0, builder.length() - 1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LicenseWedge) {
            LicenseWedge license = (LicenseWedge)obj;
            return this.repo != null && (license.repo != null && this.repo.toLowerCase().equals(license.repo.toLowerCase()) || license.title != null && this.repo.toLowerCase().equals(license.title.toLowerCase())) || this.title != null && (license.repo != null && this.title.toLowerCase().equals(license.repo.toLowerCase()) || license.title != null && this.title.toLowerCase().equals(license.title.toLowerCase())) || super.equals(obj);
        }
        return super.equals(obj);
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    @Override
    public void bind(Context context, ViewHolder viewHolder) {
        viewHolder.titleView.setText((CharSequence)ResourceUtils.getString(context, this.getName()));
        viewHolder.descriptionView.setText((CharSequence)ResourceUtils.getString(context, this.description));
        if (this.licenseName != null) {
            viewHolder.licenseView.setVisibility(0);
            viewHolder.licenseView.setText((CharSequence)ResourceUtils.getString(context, this.licenseName));
        } else {
            viewHolder.licenseView.setVisibility(8);
        }
        List<LinkWedge> links = this.getChildren(LinkWedge.class);
        if (links.size() > 0) {
            Collections.sort(links, new LinkWedge.Comparator(context));
            ArrayList<Wedge> linksList = new ArrayList<Wedge>();
            for (LinkWedge link : links) {
                if (link.isHidden()) continue;
                linksList.add(link);
            }
            viewHolder.links.setVisibility(0);
            FlexboxLayoutManager layoutManager = new FlexboxLayoutManager(context);
            layoutManager.setFlexDirection(0);
            layoutManager.setJustifyContent(0);
            viewHolder.links.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            viewHolder.links.setAdapter((RecyclerView.Adapter)new InfoAdapter(linksList));
        } else {
            viewHolder.links.setVisibility(8);
        }
        LinkWedge importantLink = null;
        for (LinkWedge link : links) {
            if (importantLink != null && link.getPriority() <= importantLink.getPriority()) continue;
            importantLink = link;
        }
        viewHolder.itemView.setOnClickListener(importantLink != null ? importantLink.getListener(context) : null);
    }

    @Override
    public LicenseWedge merge(LicenseWedge mergee) {
        if (!(this.title != null && this.title.startsWith("^") || mergee.title == null || mergee.title.isEmpty())) {
            this.title = mergee.title;
        }
        if (!(this.description != null && this.description.startsWith("^") || mergee.description == null || mergee.description.isEmpty())) {
            this.description = mergee.description;
        }
        if (!(this.licenseName != null && this.licenseName.startsWith("^") || mergee.licenseName == null)) {
            this.licenseName = mergee.licenseName;
        }
        if (!(this.websiteUrl != null && this.websiteUrl.startsWith("^") || mergee.websiteUrl == null || mergee.websiteUrl.isEmpty())) {
            this.websiteUrl = mergee.websiteUrl;
        }
        if (!(this.gitHubUrl != null && this.gitHubUrl.startsWith("^") || mergee.gitHubUrl == null)) {
            this.gitHubUrl = mergee.gitHubUrl;
        }
        if (!(this.licenseUrl != null && this.licenseUrl.startsWith("^") || mergee.licenseUrl == null)) {
            this.licenseUrl = mergee.licenseUrl;
        }
        if (mergee.licensePermissions != null) {
            this.licensePermissions = mergee.licensePermissions;
        }
        if (mergee.licenseConditions != null) {
            this.licenseConditions = mergee.licenseConditions;
        }
        if (mergee.licenseLimitations != null) {
            this.licenseLimitations = mergee.licenseLimitations;
        }
        if (mergee.licenseDescription != null) {
            this.licenseDescription = mergee.licenseDescription;
        }
        if (!(this.licenseBody != null && this.licenseBody.startsWith("^") || mergee.licenseBody == null)) {
            this.licenseBody = mergee.licenseBody;
        }
        for (Wedge child : mergee.getChildren()) {
            this.addChild(child);
        }
        return this;
    }

    @Override
    public boolean hasAll() {
        return this.hasAllGeneric() && this.hasAllLicense();
    }

    public boolean hasAllGeneric() {
        return this.description != null && this.description.startsWith("^") && this.websiteUrl != null && this.websiteUrl.startsWith("^") && this.licenseName != null && this.licenseName.startsWith("^");
    }

    public boolean hasAllLicense() {
        return this.licenseName != null && this.licenseName.startsWith("^") && this.licenseUrl != null && this.licenseUrl.startsWith("^") && this.licenseBody != null && this.licenseBody.startsWith("^");
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    static class ViewHolder
    extends Wedge.ViewHolder {
        private TextView titleView;
        private TextView descriptionView;
        private TextView licenseView;
        private RecyclerView links;

        ViewHolder(View v) {
            super(v);
            this.titleView = (TextView)v.findViewById(R.id.title);
            this.descriptionView = (TextView)v.findViewById(R.id.description);
            this.licenseView = (TextView)v.findViewById(R.id.license);
            this.links = (RecyclerView)v.findViewById(R.id.projectLinks);
        }
    }
}

