/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.wedges;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.IOException;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.data.github.GitHubData;
import me.jfenn.attribouter.data.github.UserData;
import me.jfenn.attribouter.dialogs.UserDialog;
import me.jfenn.attribouter.interfaces.Mergeable;
import me.jfenn.attribouter.utils.ResourceUtils;
import me.jfenn.attribouter.wedges.Wedge;
import me.jfenn.attribouter.wedges.link.EmailLinkWedge;
import me.jfenn.attribouter.wedges.link.GitHubLinkWedge;
import me.jfenn.attribouter.wedges.link.LinkWedge;
import me.jfenn.attribouter.wedges.link.WebsiteLinkWedge;
import org.xmlpull.v1.XmlPullParserException;

public class ContributorWedge
extends Wedge<ViewHolder>
implements Mergeable<ContributorWedge> {
    @Nullable
    public String login;
    @Nullable
    public String name;
    @Nullable
    public String avatarUrl;
    @Nullable
    public String bio;
    @Nullable
    public String blog;
    @Nullable
    public String email;
    @Nullable
    Integer position;
    @Nullable
    public String task;
    private boolean isHidden;

    public ContributorWedge(XmlResourceParser parser) throws XmlPullParserException, IOException {
        this(parser.getAttributeValue(null, "login"), parser.getAttributeValue(null, "name"), parser.getAttributeValue(null, "avatar"), parser.getAttributeValue(null, "task"), parser.getAttributeIntValue(null, "position", -1), parser.getAttributeValue(null, "bio"), parser.getAttributeValue(null, "blog"), parser.getAttributeValue(null, "email"));
        this.isHidden = parser.getAttributeBooleanValue(null, "hidden", false);
        this.addChildren(parser);
    }

    ContributorWedge(@Nullable String login, @Nullable String name, @Nullable String avatarUrl, @Nullable String task, @Nullable Integer position, @Nullable String bio, @Nullable String blog, @Nullable String email) {
        super(R.layout.item_attribouter_contributor);
        this.login = login;
        this.name = name;
        this.avatarUrl = avatarUrl;
        this.task = task;
        this.position = position != null && position >= 0 ? position : null;
        this.bio = bio;
        this.blog = blog;
        this.email = email;
        if (login != null) {
            this.addChild(new GitHubLinkWedge(login, 1));
        }
        if (blog != null) {
            this.addChild(new WebsiteLinkWedge(blog, 2));
        }
        if (email != null) {
            this.addChild(new EmailLinkWedge(email, -1));
        }
        if (login != null && !this.hasAll()) {
            this.addRequest(new UserData(login));
        }
    }

    @Override
    public void onInit(GitHubData data) {
        if (data instanceof UserData) {
            UserData user = (UserData)data;
            this.merge(new ContributorWedge(user.login, user.name, user.avatar_url, this.task == null ? "Contributor" : null, null, user.bio, user.blog, user.email));
        }
    }

    @Nullable
    public String getName() {
        return this.name != null ? this.name : this.login;
    }

    @Override
    public ContributorWedge merge(ContributorWedge contributor) {
        if (!(this.name != null && this.name.startsWith("^") || contributor.name == null)) {
            this.name = contributor.name;
        }
        if (!(this.avatarUrl != null && this.avatarUrl.startsWith("^") || contributor.avatarUrl == null)) {
            this.avatarUrl = contributor.avatarUrl;
        }
        if (!(this.bio != null && this.bio.startsWith("^") || contributor.bio == null || contributor.bio.isEmpty())) {
            this.bio = contributor.bio;
        }
        if (!(this.blog != null && this.blog.startsWith("^") || contributor.blog == null || contributor.blog.isEmpty())) {
            this.blog = contributor.blog;
        }
        if (!(this.email != null && this.email.startsWith("^") || contributor.email == null || contributor.email.isEmpty())) {
            this.email = contributor.email;
        }
        if (!(this.task != null && this.task.startsWith("^") || contributor.task == null)) {
            this.task = contributor.task;
        }
        for (Wedge child : contributor.getChildren()) {
            this.addChild(child);
        }
        return this;
    }

    @Override
    public boolean hasAll() {
        return this.name != null && this.name.startsWith("^") && this.bio != null && this.bio.startsWith("^") && this.blog != null && this.blog.startsWith("^") && this.email != null && this.email.startsWith("^");
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ContributorWedge) {
            ContributorWedge contributor = (ContributorWedge)obj;
            return this.login != null && contributor.login != null && this.login.toLowerCase().equals(contributor.login.toLowerCase()) || super.equals(obj);
        }
        return super.equals(obj);
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    @Override
    public void bind(Context context, ViewHolder viewHolder) {
        ResourceUtils.setImage(context, this.avatarUrl, viewHolder.imageView);
        viewHolder.nameView.setText((CharSequence)ResourceUtils.getString(context, this.getName()));
        if (this.task != null) {
            viewHolder.taskView.setVisibility(0);
            viewHolder.taskView.setText((CharSequence)ResourceUtils.getString(context, this.task));
        } else {
            viewHolder.taskView.setVisibility(8);
        }
        if (ResourceUtils.getString(context, this.bio) != null) {
            viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    new UserDialog(view.getContext(), ContributorWedge.this).show();
                }
            });
        } else {
            LinkWedge importantLink = null;
            for (LinkWedge link : this.getChildren(LinkWedge.class)) {
                if (link.isHidden() || importantLink != null && link.getPriority() <= importantLink.getPriority()) continue;
                importantLink = link;
            }
            viewHolder.itemView.setOnClickListener(importantLink != null ? importantLink.getListener(context) : null);
        }
    }

    static class ViewHolder
    extends Wedge.ViewHolder {
        private ImageView imageView;
        private TextView nameView;
        private TextView taskView;

        ViewHolder(View v) {
            super(v);
            this.imageView = (ImageView)v.findViewById(R.id.image);
            this.nameView = (TextView)v.findViewById(R.id.name);
            this.taskView = (TextView)v.findViewById(R.id.task);
        }
    }
}

