/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.data.github;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Semaphore;

public abstract class GitHubData {
    private String url;
    private GitHubThread thread;
    private Gson gson;
    private boolean isInitialized;
    private List<OnInitListener> listeners;
    private List<String> tags;

    GitHubData(String url) {
        this.url = url;
        this.listeners = new ArrayList<OnInitListener>();
        this.tags = new ArrayList<String>();
        this.gson = new GsonBuilder().registerTypeAdapter(this.getClass(), (Object)new MootInstanceCreator(this)).create();
    }

    private void init(String json) {
        this.initJson(this.gson, json);
        this.onInit();
        this.isInitialized = true;
        for (OnInitListener listener : this.listeners) {
            listener.onInit(this);
        }
    }

    protected void initJson(Gson gson, String json) {
        try {
            gson.fromJson(json, this.getClass());
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
            Log.e((String)"Attribouter", (String)("Error parsing JSON from " + this.url));
        }
    }

    protected void onInit() {
    }

    public final void startInit(Context context, String token) {
        this.thread = new GitHubThread(context, token, this, this.url);
        this.thread.start();
    }

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    public final GitHubData merge(GitHubData data) {
        for (OnInitListener listener : data.listeners) {
            if (this.listeners.contains(listener)) continue;
            this.listeners.add(listener);
        }
        for (String tag : data.tags) {
            this.addTag(tag);
        }
        return this;
    }

    public final void addTag(String tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    public final List<String> getTags() {
        return this.tags;
    }

    public final void addOnInitListener(OnInitListener listener) {
        this.listeners.add(listener);
    }

    public final void removeOnInitListener(OnInitListener listener) {
        this.listeners.remove(listener);
    }

    public final void interruptThread() {
        if (this.thread != null && this.thread.isAlive() && !this.thread.isInterrupted()) {
            this.thread.interrupt();
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof GitHubData && ((GitHubData)obj).url.equals(this.url);
    }

    public static interface OnInitListener {
        public void onInit(GitHubData var1);

        public void onFailure(GitHubData var1);
    }

    private static class GitHubThread
    extends Thread {
        private File cacheFile;
        private GitHubData data;
        private String url;
        private String token;
        private Context context;
        private static final int NUM_OF_PERMITS = 1;
        private Semaphore cacheToHttpSemaphore;
        private boolean continueHttpThread = false;
        private Thread cacheThread;

        private GitHubThread(Context context, String token, GitHubData data, String url) {
            this.data = data;
            this.url = url;
            this.token = token;
            this.context = context;
            this.cacheToHttpSemaphore = new Semaphore(1, true);
            this.cacheThread = this.startCacheThread();
        }

        @Override
        public void run() {
            try {
                this.cacheToHttpSemaphore.acquire();
                if (this.cacheThread.isAlive()) {
                    try {
                        this.cacheToHttpSemaphore.release();
                        this.cacheThread.join();
                        this.cacheToHttpSemaphore.acquire();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                if (this.continueHttpThread) {
                    this.doHttpConnection();
                }
            }
            finally {
                this.cacheToHttpSemaphore.release();
            }
        }

        private Thread startCacheThread() {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        GitHubThread.this.cacheToHttpSemaphore.acquire();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    try {
                        GitHubThread.this.doCacheInspection();
                    }
                    finally {
                        GitHubThread.this.cacheToHttpSemaphore.release();
                    }
                }
            });
            thread.setPriority(10);
            thread.start();
            return thread;
        }

        private void doCacheInspection() {
            File dir = new File(this.context.getCacheDir() + "/.attribouter/github");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.cacheFile = new File(dir, this.url.replace("/", ".") + ".json");
            String cache = null;
            if (Math.abs(System.currentTimeMillis() - this.cacheFile.lastModified()) < 864000000L) {
                StringBuilder cacheBuilder = new StringBuilder();
                Scanner cacheScanner = null;
                try {
                    cacheScanner = new Scanner(this.cacheFile);
                    while (cacheScanner.hasNext()) {
                        cacheBuilder.append(cacheScanner.nextLine());
                    }
                    cache = cacheBuilder.toString();
                }
                catch (IOException iOException) {
                }
                catch (Exception e) {
                    this.cacheFile.delete();
                }
                if (cacheScanner != null) {
                    cacheScanner.close();
                }
                if (cache != null) {
                    this.callInit(cache);
                } else {
                    this.continueHttpThread = true;
                }
            } else {
                this.continueHttpThread = true;
            }
        }

        private void doHttpConnection() {
            HttpURLConnection connection = null;
            BufferedReader jsonReader = null;
            StringBuilder jsonBuilder = new StringBuilder();
            try {
                String line;
                connection = (HttpURLConnection)new URL(this.url).openConnection();
                if (this.token != null) {
                    connection.setRequestProperty("Authorization", "token " + this.token);
                }
                jsonReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                if (connection.getResponseCode() == 403) {
                    jsonReader.close();
                    connection.disconnect();
                    return;
                }
                while ((line = jsonReader.readLine()) != null) {
                    if (this.isInterrupted()) {
                        connection.disconnect();
                        jsonReader.close();
                        return;
                    }
                    jsonBuilder.append(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                jsonBuilder = null;
            }
            if (connection != null) {
                connection.disconnect();
            }
            if (jsonReader != null) {
                try {
                    jsonReader.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (jsonBuilder != null) {
                String json = jsonBuilder.toString();
                this.callInit(json);
                PrintWriter cacheWriter = null;
                try {
                    cacheWriter = new PrintWriter(this.cacheFile);
                    cacheWriter.println(json);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (cacheWriter != null) {
                    cacheWriter.close();
                }
            }
        }

        private void callInit(final String json) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    GitHubThread.this.data.init(json);
                }
            });
        }
    }

    private static class MootInstanceCreator
    implements InstanceCreator<GitHubData> {
        private GitHubData instance;

        public MootInstanceCreator(GitHubData instance) {
            this.instance = instance;
        }

        public GitHubData createInstance(Type type) {
            return this.instance;
        }
    }
}

