/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.wedges;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import java.io.IOException;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.adapters.InfoAdapter;
import me.jfenn.attribouter.data.github.GitHubData;
import me.jfenn.attribouter.data.github.LicenseData;
import me.jfenn.attribouter.data.github.RepositoryData;
import me.jfenn.attribouter.dialogs.OverflowDialog;
import me.jfenn.attribouter.utils.ResourceUtils;
import me.jfenn.attribouter.wedges.LicenseWedge;
import me.jfenn.attribouter.wedges.Wedge;
import org.xmlpull.v1.XmlPullParserException;

public class LicensesWedge
extends Wedge<ViewHolder> {
    @Nullable
    private String title;
    private int overflow;

    public LicensesWedge(XmlResourceParser parser) throws XmlPullParserException, IOException {
        super(R.layout.item_attribouter_licenses);
        this.title = parser.getAttributeValue(null, "title");
        if (this.title == null) {
            this.title = "@string/title_attribouter_licenses";
        }
        boolean showDefaults = parser.getAttributeBooleanValue(null, "showDefaults", true);
        this.overflow = parser.getAttributeIntValue(null, "overflow", -1);
        this.addChildren(parser);
        if (showDefaults) {
            this.addChild(new LicenseWedge("TheAndroidMaster/Attribouter", "Attribouter", "A lightweight \"about screen\" library to allow quick but customizable attribution in Android apps.", "Apache License 2.0", null, "https://github.com/TheAndroidMaster/Attribouter", null, null, null, null, null, null, "apache-2.0"));
            this.addChild(new LicenseWedge("google/gson", "Gson", "A Java serialization/deserialization library to convert Java Objects into JSON and back", "Apache License 2.0", null, "https://github.com/google/gson", null, null, null, null, null, null, "apache-2.0"));
            this.addChild(new LicenseWedge("google/flexbox-layout", "FlexBox Layout", "FlexboxLayout is a library that brings similar capabilities to the CSS Flexible Box Layout to Android.", "Apache License 2.0", null, "https://github.com/google/flexbox-layout", null, null, null, null, null, null, "apache-2.0"));
            this.addChild(new LicenseWedge("bumptech/glide", "Glide", "An image loading and caching library for Android focused on smooth scrolling", "Other", "https://bumptech.github.io/glide/", "https://github.com/bumptech/glide", "https://raw.githubusercontent.com/bumptech/glide/master/LICENSE", null, null, null, null, null, null));
            this.addChild(new LicenseWedge(null, "Android Open Source Project", "Android is an open source software stack for a wide range of mobile devices and a corresponding open source project led by Google.", "Apache License 2.0", "https://source.android.com/license", "https://github.com/aosp-mirror", null, null, null, null, null, null, "apache-2.0"));
        }
    }

    @Override
    public void onInit(GitHubData data) {
        if (data instanceof RepositoryData) {
            RepositoryData repo = (RepositoryData)data;
            for (String tag : repo.getTags()) {
                LicenseWedge mergeLicense = new LicenseWedge(tag, null, repo.description, repo.license != null ? repo.license.name : null, repo.homepage, "https://github.com/" + tag, null, null, null, null, null, null, null);
                if (!this.getChildren().contains(mergeLicense)) continue;
                Wedge info = this.getChildren().get(this.getChildren().indexOf(mergeLicense));
                if (!(info instanceof LicenseWedge)) break;
                LicenseWedge license = (LicenseWedge)info;
                license.merge(mergeLicense);
                if (repo.license != null && repo.license.key != null && !license.hasAllLicense()) {
                    LicenseData request = new LicenseData(repo.license.key);
                    request.addTag(tag);
                    this.addRequest(request);
                }
                break;
            }
        } else if (data instanceof LicenseData) {
            LicenseData license = (LicenseData)data;
            for (Wedge info : this.getChildren()) {
                if (!(info instanceof LicenseWedge)) continue;
                LicenseWedge licenseInfo = (LicenseWedge)info;
                if (!license.getTags().contains(licenseInfo.token)) continue;
                licenseInfo.merge(new LicenseWedge(null, null, null, license.name, null, "https://github.com/" + licenseInfo.repo, license.html_url, license.permissions, license.conditions, license.limitations, license.description, license.body, license.key));
            }
        }
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    @Override
    public void bind(Context context, ViewHolder viewHolder) {
        if (this.overflow == 0) {
            viewHolder.titleView.setVisibility(8);
            viewHolder.recycler.setVisibility(8);
            viewHolder.expand.setVisibility(8);
            viewHolder.overflow.setVisibility(0);
            viewHolder.overflow.setText((CharSequence)String.format(context.getString(R.string.title_attribouter_view_overflow), ResourceUtils.getString(context, this.title)));
            viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    new OverflowDialog(v.getContext(), LicensesWedge.this.title, LicensesWedge.this.getChildren()).show();
                }
            });
            return;
        }
        viewHolder.titleView.setVisibility(0);
        viewHolder.recycler.setVisibility(0);
        viewHolder.expand.setVisibility(0);
        viewHolder.overflow.setVisibility(8);
        viewHolder.itemView.setOnClickListener(null);
        if (this.title != null) {
            viewHolder.titleView.setText((CharSequence)ResourceUtils.getString(context, this.title));
        }
        viewHolder.recycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        viewHolder.recycler.setAdapter((RecyclerView.Adapter)new InfoAdapter(this.getChildren().subList(0, this.overflow > this.getChildren().size() || this.overflow < 0 ? this.getChildren().size() : this.overflow)));
        if (this.overflow > 0 && this.overflow < this.getChildren().size()) {
            viewHolder.expand.setVisibility(0);
            viewHolder.expand.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    new OverflowDialog(v.getContext(), LicensesWedge.this.title, LicensesWedge.this.getChildren()).show();
                }
            });
        } else {
            viewHolder.expand.setVisibility(8);
        }
    }

    static class ViewHolder
    extends Wedge.ViewHolder {
        private TextView titleView;
        private RecyclerView recycler;
        private View expand;
        private TextView overflow;

        ViewHolder(View v) {
            super(v);
            this.titleView = (TextView)v.findViewById(R.id.title);
            this.recycler = (RecyclerView)v.findViewById(R.id.recycler);
            this.expand = v.findViewById(R.id.expand);
            this.overflow = (TextView)v.findViewById(R.id.overflow);
        }
    }
}

