/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.data.info;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.data.info.InfoData;
import me.jfenn.attribouter.utils.ResourceUtils;
import me.jfenn.attribouter.utils.UrlClickListener;

public class TranslatorInfoData
extends InfoData<ViewHolder> {
    @Nullable
    public String login;
    @Nullable
    public String name;
    @Nullable
    public String avatarUrl;
    @Nullable
    public String blog;
    @Nullable
    public String email;
    @Nullable
    public String locales;

    TranslatorInfoData(XmlResourceParser parser) {
        this(parser.getAttributeValue(null, "login"), parser.getAttributeValue(null, "name"), parser.getAttributeValue(null, "avatar"), parser.getAttributeValue(null, "locales"), parser.getAttributeValue(null, "blog"), parser.getAttributeValue(null, "email"));
    }

    TranslatorInfoData(@Nullable String login, @Nullable String name, @Nullable String avatarUrl, @Nullable String locales, @Nullable String blog, @Nullable String email) {
        super(R.layout.item_attribouter_translator);
        this.login = login;
        this.name = name;
        this.avatarUrl = avatarUrl;
        this.locales = locales;
        this.blog = blog;
        this.email = email;
    }

    @Nullable
    public String getName() {
        return this.name != null ? this.name : this.login;
    }

    public void merge(TranslatorInfoData contributor) {
        if (!(this.name != null && this.name.startsWith("^") || contributor.name == null)) {
            this.name = contributor.name;
        }
        if (!(this.avatarUrl != null && this.avatarUrl.startsWith("^") || contributor.avatarUrl == null)) {
            this.avatarUrl = contributor.avatarUrl;
        }
        if (!(this.blog != null && this.blog.startsWith("^") || contributor.blog == null || contributor.blog.isEmpty())) {
            this.blog = contributor.blog;
        }
        if (!(this.email != null && this.email.startsWith("^") || contributor.email == null || contributor.email.isEmpty())) {
            this.email = contributor.email;
        }
        if (!(this.locales != null && this.locales.startsWith("^") || contributor.locales == null)) {
            this.locales = contributor.locales;
        }
    }

    public boolean hasEverything() {
        return this.name != null && this.name.startsWith("^") && this.blog != null && this.blog.startsWith("^");
    }

    public boolean equals(Object obj) {
        if (obj instanceof TranslatorInfoData) {
            TranslatorInfoData translator = (TranslatorInfoData)obj;
            return this.login != null && translator.login != null && this.login.toLowerCase().equals(translator.login.toLowerCase()) || super.equals(obj);
        }
        return super.equals(obj);
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    @Override
    public void bind(Context context, ViewHolder viewHolder) {
        ResourceUtils.setImage(context, this.avatarUrl, viewHolder.imageView);
        viewHolder.nameView.setText((CharSequence)ResourceUtils.getString(context, this.getName()));
        String blog = ResourceUtils.getString(context, this.blog);
        if (blog != null) {
            viewHolder.itemView.setOnClickListener((View.OnClickListener)new UrlClickListener(blog));
        } else if (this.login != null) {
            viewHolder.itemView.setOnClickListener((View.OnClickListener)new UrlClickListener("https://github.com/" + this.login));
        } else {
            viewHolder.itemView.setOnClickListener(null);
        }
    }

    static class ViewHolder
    extends InfoData.ViewHolder {
        private ImageView imageView;
        private TextView nameView;

        ViewHolder(View v) {
            super(v);
            this.imageView = (ImageView)v.findViewById(R.id.image);
            this.nameView = (TextView)v.findViewById(R.id.name);
        }
    }
}

