/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.data.info;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import me.jfenn.attribouter.data.github.GitHubData;

public abstract class InfoData<T extends ViewHolder>
implements GitHubData.OnInitListener {
    private int layoutRes;
    private List<GitHubData> requests;
    private OnRequestListener listener;

    public InfoData(@LayoutRes int layoutRes) {
        this.layoutRes = layoutRes;
        this.requests = new ArrayList<GitHubData>();
    }

    protected void addRequest(GitHubData request) {
        request.addOnInitListener(this);
        this.requests.add(request);
        if (this.listener != null) {
            this.listener.onRequest(this, request);
        }
    }

    public final void setOnRequestListener(OnRequestListener listener) {
        this.listener = listener;
    }

    public final List<GitHubData> getRequests() {
        return this.requests;
    }

    public final boolean hasRequest(GitHubData request) {
        return this.requests.contains(request);
    }

    public final int getLayoutRes() {
        return this.layoutRes;
    }

    public abstract T getViewHolder(View var1);

    public abstract void bind(Context var1, T var2);

    @Override
    public void onInit(GitHubData data) {
    }

    @Override
    public void onFailure(GitHubData data) {
    }

    public static interface OnRequestListener {
        public void onRequest(InfoData var1, GitHubData var2);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        public ViewHolder(View v) {
            super(v);
        }
    }
}

