/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.data.info;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.flexbox.FlexboxLayoutManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.adapters.InfoAdapter;
import me.jfenn.attribouter.data.github.GitHubData;
import me.jfenn.attribouter.data.github.RepositoryData;
import me.jfenn.attribouter.data.info.InfoData;
import me.jfenn.attribouter.data.info.link.GitHubLinkInfoData;
import me.jfenn.attribouter.data.info.link.LinkInfoData;
import me.jfenn.attribouter.data.info.link.PlayStoreLinkInfoData;
import me.jfenn.attribouter.data.info.link.WebsiteLinkInfoData;
import me.jfenn.attribouter.utils.ResourceUtils;
import org.xmlpull.v1.XmlPullParserException;

public class AppInfoData
extends InfoData<ViewHolder> {
    @Nullable
    private String icon;
    @Nullable
    private String description;
    @Nullable
    private String playStoreUrl;
    @Nullable
    private String websiteUrl;
    @Nullable
    private String gitHubUrl;
    private List<LinkInfoData> links;

    public AppInfoData(XmlResourceParser parser) throws IOException, XmlPullParserException {
        super(R.layout.item_attribouter_app_info);
        this.icon = parser.getAttributeValue(null, "icon");
        this.description = parser.getAttributeValue(null, "description");
        this.playStoreUrl = parser.getAttributeValue(null, "playStoreUrl");
        this.websiteUrl = parser.getAttributeValue(null, "websiteUrl");
        this.gitHubUrl = parser.getAttributeValue(null, "gitHubUrl");
        String repo = parser.getAttributeValue(null, "repo");
        if (this.gitHubUrl == null && repo != null) {
            this.gitHubUrl = "https://github.com/" + repo;
        }
        this.links = new ArrayList<LinkInfoData>();
        if (repo != null || this.gitHubUrl != null) {
            this.links.add(new GitHubLinkInfoData(this.gitHubUrl != null ? this.gitHubUrl : repo, 0, this.gitHubUrl != null));
        }
        if (this.websiteUrl != null) {
            this.links.add(new WebsiteLinkInfoData(this.websiteUrl, 0));
        }
        this.links.add(new PlayStoreLinkInfoData(this.playStoreUrl, 0));
        while (parser.next() != 3 || parser.getName().equals("link")) {
            if (parser.getEventType() != 2 || !parser.getName().equals("link")) continue;
            LinkInfoData link = new LinkInfoData(parser);
            if (this.links.contains(link)) {
                this.links.get(this.links.indexOf(link)).merge(link);
                continue;
            }
            this.links.add(link);
        }
        this.addRequest(new RepositoryData(repo));
    }

    @Override
    public void onInit(GitHubData data) {
        if (data instanceof RepositoryData) {
            RepositoryData repository = (RepositoryData)data;
            if (!(this.description != null && this.description.startsWith("^") || repository.description == null)) {
                this.description = repository.description;
            }
            ArrayList<LinkInfoData> newLinks = new ArrayList<LinkInfoData>();
            if (repository.html_url != null) {
                newLinks.add(new GitHubLinkInfoData(repository.html_url, 0, true));
            }
            if (repository.homepage != null) {
                newLinks.add(repository.homepage.startsWith("https://play.google.com/") ? new PlayStoreLinkInfoData(repository.homepage, 0) : new WebsiteLinkInfoData(repository.homepage, 0));
            }
            for (LinkInfoData link : newLinks) {
                if (this.links.contains(link)) {
                    this.links.get(this.links.indexOf(link)).merge(link);
                    continue;
                }
                this.links.add(link);
            }
        }
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    @Override
    public void bind(Context context, ViewHolder viewHolder) {
        ApplicationInfo info = context.getApplicationInfo();
        ResourceUtils.setImage(context, this.icon, info.icon, viewHolder.appIconView);
        viewHolder.nameTextView.setText(info.labelRes);
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(info.packageName, 0);
            viewHolder.versionTextView.setText((CharSequence)String.format(context.getString(R.string.title_attribouter_version), packageInfo.versionName));
            viewHolder.versionTextView.setVisibility(0);
        }
        catch (PackageManager.NameNotFoundException e) {
            viewHolder.versionTextView.setVisibility(8);
        }
        if (this.description != null) {
            viewHolder.descriptionTextView.setVisibility(0);
            viewHolder.descriptionTextView.setText((CharSequence)ResourceUtils.getString(context, this.description));
        } else {
            viewHolder.descriptionTextView.setVisibility(8);
        }
        if (this.links.size() > 0) {
            Collections.sort(this.links, new LinkInfoData.Comparator(context));
            ArrayList<InfoData> linksList = new ArrayList<InfoData>();
            for (LinkInfoData link : this.links) {
                if (link.isHidden()) continue;
                linksList.add(link);
            }
            viewHolder.links.setVisibility(0);
            FlexboxLayoutManager layoutManager = new FlexboxLayoutManager(context);
            layoutManager.setFlexDirection(0);
            layoutManager.setJustifyContent(2);
            viewHolder.links.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            viewHolder.links.setAdapter((RecyclerView.Adapter)new InfoAdapter(linksList));
        } else {
            viewHolder.links.setVisibility(8);
        }
    }

    static class ViewHolder
    extends InfoData.ViewHolder {
        ImageView appIconView;
        TextView nameTextView;
        TextView versionTextView;
        TextView descriptionTextView;
        RecyclerView links;

        private ViewHolder(View v) {
            super(v);
            this.appIconView = (ImageView)v.findViewById(R.id.appIcon);
            this.nameTextView = (TextView)v.findViewById(R.id.appName);
            this.versionTextView = (TextView)v.findViewById(R.id.appVersion);
            this.descriptionTextView = (TextView)v.findViewById(R.id.description);
            this.links = (RecyclerView)v.findViewById(R.id.appLinks);
        }
    }
}

