/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.dialogs;

import android.content.Context;
import android.os.Bundle;
import android.support.v7.app.AppCompatDialog;
import android.support.v7.widget.RecyclerView;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.flexbox.FlexboxLayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.adapters.InfoAdapter;
import me.jfenn.attribouter.data.info.ContributorInfoData;
import me.jfenn.attribouter.data.info.InfoData;
import me.jfenn.attribouter.data.info.link.LinkInfoData;
import me.jfenn.attribouter.utils.ResourceUtils;

public class UserDialog
extends AppCompatDialog {
    private ContributorInfoData contributor;

    public UserDialog(Context context, ContributorInfoData contributor) {
        super(context);
        this.contributor = contributor;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dialog_attribouter_user);
        TextView nameView = (TextView)this.findViewById(R.id.name);
        TextView taskView = (TextView)this.findViewById(R.id.task);
        ImageView imageView = (ImageView)this.findViewById(R.id.image);
        TextView bioView = (TextView)this.findViewById(R.id.description);
        RecyclerView links = (RecyclerView)this.findViewById(R.id.links);
        nameView.setText((CharSequence)ResourceUtils.getString(this.getContext(), this.contributor.getName()));
        taskView.setText((CharSequence)ResourceUtils.getString(this.getContext(), this.contributor.task));
        String url = ResourceUtils.getString(this.getContext(), this.contributor.avatarUrl);
        if (url != null) {
            ResourceUtils.setImage(this.getContext(), this.contributor.avatarUrl, imageView);
        } else {
            imageView.setVisibility(8);
        }
        bioView.setText((CharSequence)ResourceUtils.getString(this.getContext(), this.contributor.bio));
        if (this.contributor.links.size() > 0) {
            Collections.sort(this.contributor.links);
            ArrayList<InfoData> linksList = new ArrayList<InfoData>();
            for (LinkInfoData link : this.contributor.links) {
                if (link.isHidden()) continue;
                linksList.add(link);
            }
            links.setVisibility(0);
            FlexboxLayoutManager layoutManager = new FlexboxLayoutManager(this.getContext());
            layoutManager.setFlexDirection(0);
            layoutManager.setJustifyContent(0);
            links.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            links.setAdapter((RecyclerView.Adapter)new InfoAdapter(linksList));
        } else {
            links.setVisibility(8);
        }
    }
}

