/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.data.info.link;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.data.info.InfoData;
import me.jfenn.attribouter.utils.ResourceUtils;
import me.jfenn.attribouter.utils.UrlClickListener;

public class LinkInfoData
extends InfoData<ViewHolder>
implements Comparable<LinkInfoData> {
    @Nullable
    private String id;
    @Nullable
    private String name;
    @Nullable
    private String url;
    @Nullable
    private String icon;
    int priority;

    public LinkInfoData(XmlResourceParser parser) {
        this(parser.getAttributeValue(null, "id"), parser.getAttributeValue(null, "name"), parser.getAttributeValue(null, "url"), parser.getAttributeValue(null, "icon"), 0);
        String priorityString = parser.getAttributeValue(null, "priority");
        if (priorityString != null) {
            this.priority = Integer.parseInt(priorityString);
        }
    }

    public LinkInfoData(@Nullable String id2, @Nullable String name, @Nullable String url, @Nullable String icon, int priority) {
        super(R.layout.item_attribouter_link);
        this.id = id2;
        this.name = name;
        this.url = url;
        this.icon = icon;
        this.priority = priority;
    }

    public LinkInfoData merge(LinkInfoData link) {
        if (this.id == null && link.id != null) {
            this.id = link.id;
        }
        if (!(this.name != null && this.name.startsWith("^") || link.name == null)) {
            this.name = link.name;
        }
        if (!(this.url != null && this.url.startsWith("^") || link.url == null)) {
            this.url = link.url;
        }
        if (!(this.icon != null && this.icon.startsWith("^") || link.icon == null)) {
            this.icon = link.icon;
        }
        if (link.priority != 0) {
            this.priority = link.priority;
        }
        return this;
    }

    @Nullable
    public String getName(Context context) {
        return ResourceUtils.getString(context, this.name);
    }

    @Nullable
    public View.OnClickListener getListener(Context context) {
        if (this.url != null) {
            return new UrlClickListener(ResourceUtils.getString(context, this.url));
        }
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    String getUrl() {
        return this.url;
    }

    public void loadIcon(ImageView imageView) {
        ResourceUtils.setImage(imageView.getContext(), this.icon, imageView);
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof LinkInfoData && (this.id != null && this.id.equals(((LinkInfoData)obj).id) || (this.url != null ? this.url.equals(((LinkInfoData)obj).url) : super.equals(obj)));
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    @Override
    public void bind(Context context, ViewHolder viewHolder) {
        viewHolder.nameView.setText((CharSequence)this.getName(context));
        this.loadIcon(viewHolder.iconView);
        viewHolder.itemView.setOnClickListener(this.getListener(context));
    }

    @Override
    public int compareTo(@NonNull LinkInfoData o) {
        int comparison = this.name != null && o.name != null ? this.name.compareTo(o.name) : 0;
        return (o.priority - this.priority) * 2 + comparison / Math.abs(comparison);
    }

    public static class ViewHolder
    extends InfoData.ViewHolder {
        private TextView nameView;
        private ImageView iconView;

        ViewHolder(View v) {
            super(v);
            this.nameView = (TextView)v.findViewById(R.id.name);
            this.iconView = (ImageView)v.findViewById(R.id.icon);
        }
    }
}

