/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.data.info;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.adapters.InfoAdapter;
import me.jfenn.attribouter.data.github.ContributorsData;
import me.jfenn.attribouter.data.github.GitHubData;
import me.jfenn.attribouter.data.github.UserData;
import me.jfenn.attribouter.data.info.HeaderInfoData;
import me.jfenn.attribouter.data.info.InfoData;
import me.jfenn.attribouter.data.info.TranslatorInfoData;
import me.jfenn.attribouter.dialogs.OverflowDialog;
import me.jfenn.attribouter.utils.ResourceUtils;
import org.xmlpull.v1.XmlPullParserException;

public class TranslatorsInfoData
extends InfoData<ViewHolder> {
    @Nullable
    private String translatorsTitle;
    private List<TranslatorInfoData> translators = new ArrayList<TranslatorInfoData>();
    private List<InfoData> sortedTranslators;
    private int overflow;

    public TranslatorsInfoData(XmlResourceParser parser) throws XmlPullParserException, IOException {
        super(R.layout.item_attribouter_translators);
        this.translatorsTitle = parser.getAttributeValue(null, "title");
        if (this.translatorsTitle == null) {
            this.translatorsTitle = "@string/title_attribouter_translators";
        }
        this.overflow = parser.getAttributeIntValue(null, "overflow", -1);
        while (parser.getEventType() != 3 || parser.getName().equals("translator")) {
            parser.next();
            if (parser.getEventType() != 2 || !parser.getName().equals("translator")) continue;
            TranslatorInfoData translator = new TranslatorInfoData(parser);
            if (!this.translators.contains(translator)) {
                this.translators.add(translator);
            } else {
                this.translators.get(this.translators.indexOf(translator)).merge(translator);
            }
            if (translator.login == null || translator.hasEverything()) continue;
            this.addRequest(new UserData(translator.login));
        }
    }

    @Override
    public void onInit(GitHubData data) {
        if (data instanceof ContributorsData) {
            if (((ContributorsData)data).contributors != null) {
                for (ContributorsData.ContributorData contributor : ((ContributorsData)data).contributors) {
                    TranslatorInfoData mergeTranslator;
                    if (contributor.login == null) continue;
                    TranslatorInfoData translatorInfo = mergeTranslator = new TranslatorInfoData(contributor.login, null, contributor.avatar_url, null, null, null);
                    if (this.translators.contains(mergeTranslator)) {
                        translatorInfo = this.translators.get(this.translators.indexOf(mergeTranslator));
                        translatorInfo.merge(mergeTranslator);
                    } else {
                        this.translators.add(translatorInfo);
                    }
                    if (translatorInfo.hasEverything()) continue;
                    this.addRequest(new UserData(contributor.login));
                }
            }
        } else if (data instanceof UserData) {
            UserData user = (UserData)data;
            TranslatorInfoData translator = new TranslatorInfoData(user.login, user.name, user.avatar_url, null, user.blog, user.email);
            if (!this.translators.contains(translator)) {
                this.translators.add(0, translator);
            } else {
                this.translators.get(this.translators.indexOf(translator)).merge(translator);
            }
        }
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    @Override
    public void bind(Context context, ViewHolder viewHolder) {
        if (this.overflow == 0) {
            viewHolder.titleView.setVisibility(8);
            viewHolder.recycler.setVisibility(8);
            viewHolder.expand.setVisibility(8);
            viewHolder.overflow.setVisibility(0);
            viewHolder.overflow.setText((CharSequence)String.format(context.getString(R.string.title_attribouter_view_overflow), this.translatorsTitle));
            viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    new OverflowDialog(v.getContext(), TranslatorsInfoData.this.translatorsTitle, TranslatorsInfoData.this.sortedTranslators).show();
                }
            });
            return;
        }
        viewHolder.titleView.setVisibility(0);
        viewHolder.recycler.setVisibility(0);
        viewHolder.expand.setVisibility(0);
        viewHolder.overflow.setVisibility(8);
        viewHolder.itemView.setOnClickListener(null);
        if (this.translatorsTitle != null) {
            viewHolder.titleView.setText((CharSequence)ResourceUtils.getString(context, this.translatorsTitle));
        }
        int remaining = this.overflow;
        ArrayList<InfoData> sortedList = new ArrayList<InfoData>();
        this.sortedTranslators = new ArrayList<InfoData>();
        for (String language : Locale.getISOLanguages()) {
            boolean isHeader = false;
            for (TranslatorInfoData translator : this.translators) {
                if (translator.locales == null) continue;
                boolean isLocale = false;
                for (String locale : translator.locales.split(",")) {
                    if (!language.equals(locale)) continue;
                    isLocale = true;
                    break;
                }
                if (!isLocale) continue;
                if (!isHeader) {
                    HeaderInfoData header = new HeaderInfoData(new Locale(language).getDisplayLanguage());
                    this.sortedTranslators.add(header);
                    if (remaining != 0) {
                        sortedList.add(header);
                    }
                    isHeader = true;
                }
                this.sortedTranslators.add(translator);
                if (remaining == 0) continue;
                sortedList.add(translator);
                --remaining;
            }
        }
        viewHolder.recycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        viewHolder.recycler.setAdapter((RecyclerView.Adapter)new InfoAdapter(sortedList));
        if (this.sortedTranslators.size() > sortedList.size()) {
            viewHolder.expand.setVisibility(0);
            viewHolder.expand.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    new OverflowDialog(v.getContext(), TranslatorsInfoData.this.translatorsTitle, TranslatorsInfoData.this.sortedTranslators).show();
                }
            });
        } else {
            viewHolder.expand.setVisibility(8);
        }
    }

    class ViewHolder
    extends InfoData.ViewHolder {
        private TextView titleView;
        private RecyclerView recycler;
        private View expand;
        private TextView overflow;

        ViewHolder(View v) {
            super(v);
            this.titleView = (TextView)v.findViewById(R.id.contributorsTitle);
            this.recycler = (RecyclerView)v.findViewById(R.id.recycler);
            this.expand = v.findViewById(R.id.expand);
            this.overflow = (TextView)v.findViewById(R.id.overflow);
        }
    }
}

