/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.data.info;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.data.info.InfoData;
import me.jfenn.attribouter.data.info.link.EmailLinkInfoData;
import me.jfenn.attribouter.data.info.link.GitHubLinkInfoData;
import me.jfenn.attribouter.data.info.link.LinkInfoData;
import me.jfenn.attribouter.data.info.link.WebsiteLinkInfoData;
import me.jfenn.attribouter.dialogs.UserDialog;
import me.jfenn.attribouter.utils.ResourceUtils;
import org.xmlpull.v1.XmlPullParserException;

public class ContributorInfoData
extends InfoData<ViewHolder> {
    @Nullable
    public String login;
    @Nullable
    public String name;
    @Nullable
    public String avatarUrl;
    @Nullable
    public String bio;
    @Nullable
    public String blog;
    @Nullable
    public String email;
    @Nullable
    Integer position;
    @Nullable
    public String task;
    public List<LinkInfoData> links;
    boolean isHidden;

    ContributorInfoData(XmlResourceParser parser, @Nullable Integer position) throws XmlPullParserException, IOException {
        this(parser.getAttributeValue(null, "login"), parser.getAttributeValue(null, "name"), parser.getAttributeValue(null, "avatar"), parser.getAttributeValue(null, "task"), position, parser.getAttributeValue(null, "bio"), parser.getAttributeValue(null, "blog"), parser.getAttributeValue(null, "email"));
        this.isHidden = parser.getAttributeBooleanValue(null, "hidden", false);
        while (parser.next() != 3 || parser.getName().equals("link")) {
            if (parser.getEventType() != 2 || !parser.getName().equals("link")) continue;
            LinkInfoData link = new LinkInfoData(parser);
            if (this.links.contains(link)) {
                this.links.get(this.links.indexOf(link)).merge(link);
                continue;
            }
            this.links.add(link);
        }
    }

    ContributorInfoData(@Nullable String login, @Nullable String name, @Nullable String avatarUrl, @Nullable String task, @Nullable Integer position, @Nullable String bio, @Nullable String blog, @Nullable String email) {
        super(R.layout.item_attribouter_contributor);
        this.login = login;
        this.name = name;
        this.avatarUrl = avatarUrl;
        this.task = task;
        this.position = position;
        this.bio = bio;
        this.blog = blog;
        this.email = email;
        this.links = new ArrayList<LinkInfoData>();
        if (login != null) {
            this.links.add(new GitHubLinkInfoData(login, 1));
        }
        if (blog != null) {
            this.links.add(new WebsiteLinkInfoData(blog, 2));
        }
        if (email != null) {
            this.links.add(new EmailLinkInfoData(email, -1));
        }
    }

    @Nullable
    public String getName() {
        return this.name != null ? this.name : this.login;
    }

    public void merge(ContributorInfoData contributor) {
        if (!(this.name != null && this.name.startsWith("^") || contributor.name == null)) {
            this.name = contributor.name;
        }
        if (!(this.avatarUrl != null && this.avatarUrl.startsWith("^") || contributor.avatarUrl == null)) {
            this.avatarUrl = contributor.avatarUrl;
        }
        if (!(this.bio != null && this.bio.startsWith("^") || contributor.bio == null || contributor.bio.isEmpty())) {
            this.bio = contributor.bio;
        }
        if (!(this.blog != null && this.blog.startsWith("^") || contributor.blog == null || contributor.blog.isEmpty())) {
            this.blog = contributor.blog;
        }
        if (!(this.email != null && this.email.startsWith("^") || contributor.email == null || contributor.email.isEmpty())) {
            this.email = contributor.email;
        }
        if (!(this.task != null && this.task.startsWith("^") || contributor.task == null)) {
            this.task = contributor.task;
        }
        for (LinkInfoData link : contributor.links) {
            if (this.links.contains(link)) {
                this.links.get(this.links.indexOf(link)).merge(link);
                continue;
            }
            this.links.add(link);
        }
    }

    public boolean hasEverything() {
        return this.name != null && this.name.startsWith("^") && this.bio != null && this.bio.startsWith("^") && this.blog != null && this.blog.startsWith("^") && this.email != null && this.email.startsWith("^");
    }

    public boolean equals(Object obj) {
        return obj instanceof ContributorInfoData && (this.login != null ? this.login.equals(((ContributorInfoData)obj).login) : super.equals(obj));
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    @Override
    public void bind(Context context, ViewHolder viewHolder) {
        ResourceUtils.setImage(context, this.avatarUrl, viewHolder.imageView);
        viewHolder.nameView.setText((CharSequence)ResourceUtils.getString(context, this.getName()));
        if (this.task != null) {
            viewHolder.taskView.setVisibility(0);
            viewHolder.taskView.setText((CharSequence)ResourceUtils.getString(context, this.task));
        } else {
            viewHolder.taskView.setVisibility(8);
        }
        if (ResourceUtils.getString(context, this.bio) != null) {
            viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    new UserDialog(view.getContext(), ContributorInfoData.this).show();
                }
            });
        } else {
            LinkInfoData importantLink = null;
            for (LinkInfoData link : this.links) {
                if (importantLink != null && link.getPriority() <= importantLink.getPriority()) continue;
                importantLink = link;
            }
            viewHolder.itemView.setOnClickListener(importantLink != null ? importantLink.getListener(context) : null);
        }
    }

    static class ViewHolder
    extends InfoData.ViewHolder {
        private ImageView imageView;
        private TextView nameView;
        private TextView taskView;

        ViewHolder(View v) {
            super(v);
            this.imageView = (ImageView)v.findViewById(R.id.image);
            this.nameView = (TextView)v.findViewById(R.id.name);
            this.taskView = (TextView)v.findViewById(R.id.task);
        }
    }
}

