/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.data.info;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import com.google.android.flexbox.FlexboxLayoutManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.adapters.InfoAdapter;
import me.jfenn.attribouter.data.info.InfoData;
import me.jfenn.attribouter.data.info.link.GitHubLinkInfoData;
import me.jfenn.attribouter.data.info.link.LicenseLinkInfoData;
import me.jfenn.attribouter.data.info.link.LinkInfoData;
import me.jfenn.attribouter.data.info.link.WebsiteLinkInfoData;
import me.jfenn.attribouter.utils.ResourceUtils;
import org.xmlpull.v1.XmlPullParserException;

public class LicenseInfoData
extends InfoData<ViewHolder> {
    @Nullable
    String token;
    @Nullable
    String repo;
    @Nullable
    String title;
    @Nullable
    String description;
    @Nullable
    public String licenseName;
    @Nullable
    String websiteUrl;
    @Nullable
    String gitHubUrl;
    @Nullable
    public String licenseUrl;
    @Nullable
    String[] licensePermissions;
    @Nullable
    String[] licenseConditions;
    @Nullable
    String[] licenseLimitations;
    @Nullable
    public String licenseDescription;
    @Nullable
    public String licenseBody;
    @Nullable
    String licenseKey;
    List<LinkInfoData> links;

    public LicenseInfoData(XmlResourceParser parser) throws IOException, XmlPullParserException {
        this(parser.getAttributeValue(null, "repo"), parser.getAttributeValue(null, "title"), parser.getAttributeValue(null, "description"), parser.getAttributeValue(null, "licenseName"), parser.getAttributeValue(null, "website"), parser.getAttributeValue(null, "gitHubUrl"), parser.getAttributeValue(null, "licenseUrl"), null, null, null, null, parser.getAttributeValue(null, "licenseBody"), parser.getAttributeValue(null, "license"));
        while (parser.next() != 3 || parser.getName().equals("link")) {
            if (parser.getEventType() != 2 || !parser.getName().equals("link")) continue;
            LinkInfoData link = new LinkInfoData(parser);
            if (this.links.contains(link)) {
                this.links.get(this.links.indexOf(link)).merge(link);
                continue;
            }
            this.links.add(link);
        }
    }

    public LicenseInfoData(@Nullable String repo, @Nullable String title, @Nullable String description, @Nullable String licenseName, @Nullable String websiteUrl, @Nullable String gitHubUrl, @Nullable String licenseUrl, @Nullable String[] licensePermissions, @Nullable String[] licenseConditions, @Nullable String[] licenseLimitations, @Nullable String licenseDescription, @Nullable String licenseBody, @Nullable String licenseKey) {
        super(R.layout.item_attribouter_license);
        this.repo = repo;
        this.title = title;
        this.description = description;
        this.licenseName = licenseName;
        this.websiteUrl = websiteUrl;
        this.gitHubUrl = gitHubUrl;
        this.licenseUrl = licenseUrl;
        this.licensePermissions = licensePermissions;
        this.licenseConditions = licenseConditions;
        this.licenseLimitations = licenseLimitations;
        this.licenseDescription = licenseDescription;
        this.licenseBody = licenseBody;
        this.licenseKey = licenseKey;
        this.token = repo != null ? repo : title;
        this.links = new ArrayList<LinkInfoData>();
        if (websiteUrl != null) {
            this.links.add(new WebsiteLinkInfoData(websiteUrl, 2));
        }
        if (repo != null) {
            this.links.add(new GitHubLinkInfoData(repo, 1));
        }
        if (licenseBody != null || licenseUrl != null) {
            this.links.add(new LicenseLinkInfoData(this, 0));
        }
    }

    public String getName() {
        if (this.title != null) {
            return this.title;
        }
        if (this.repo != null) {
            String name = this.repo;
            if (name.contains("/")) {
                String[] names = name.split("/");
                name = names.length > 1 && names[1].length() > 0 ? names[1] : names[0];
            }
            name = name.replace('-', ' ').replace('_', ' ').replaceAll("([a-z])([A-Z])", "$1 $2").replaceAll("([A-Z])([A-Z][a-z])", "$1 $2").trim();
            StringBuffer nameBuffer = new StringBuffer();
            Pattern pattern = Pattern.compile("\\b(\\w)");
            Matcher matcher = pattern.matcher(name);
            while (matcher.find()) {
                matcher.appendReplacement(nameBuffer, matcher.group(1).toUpperCase());
            }
            return matcher.appendTail(nameBuffer).toString();
        }
        return null;
    }

    public String getLicensePermissions() {
        if (this.licensePermissions == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String permission : this.licensePermissions) {
            if (permission.length() <= 1) continue;
            builder.append(String.valueOf(permission.charAt(0)).toUpperCase()).append(permission.replace('-', ' ').substring(1)).append("\n");
        }
        return builder.substring(0, builder.length() - 1);
    }

    public String getLicenseConditions() {
        if (this.licenseConditions == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String condition : this.licenseConditions) {
            if (condition.length() <= 1) continue;
            builder.append(String.valueOf(condition.charAt(0)).toUpperCase()).append(condition.replace('-', ' ').substring(1)).append("\n");
        }
        return builder.substring(0, builder.length() - 1);
    }

    public String getLicenseLimitations() {
        if (this.licenseLimitations == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String limitation : this.licenseLimitations) {
            if (limitation.length() <= 1) continue;
            builder.append(String.valueOf(limitation.charAt(0)).toUpperCase()).append(limitation.replace('-', ' ').substring(1)).append("\n");
        }
        return builder.substring(0, builder.length() - 1);
    }

    public void merge(LicenseInfoData license) {
        if (!(this.title != null && this.title.startsWith("^") || license.title == null || license.title.isEmpty())) {
            this.title = license.title;
        }
        if (!(this.description != null && this.description.startsWith("^") || license.description == null || license.description.isEmpty())) {
            this.description = license.description;
        }
        if (!(this.licenseName != null && this.licenseName.startsWith("^") || license.licenseName == null)) {
            this.licenseName = license.licenseName;
        }
        if (!(this.websiteUrl != null && this.websiteUrl.startsWith("^") || license.websiteUrl == null || license.websiteUrl.isEmpty())) {
            this.websiteUrl = license.websiteUrl;
        }
        if (!(this.gitHubUrl != null && this.gitHubUrl.startsWith("^") || license.gitHubUrl == null)) {
            this.gitHubUrl = license.gitHubUrl;
        }
        if (!(this.licenseUrl != null && this.licenseUrl.startsWith("^") || license.licenseUrl == null)) {
            this.licenseUrl = license.licenseUrl;
        }
        if (license.licensePermissions != null) {
            this.licensePermissions = license.licensePermissions;
        }
        if (license.licenseConditions != null) {
            this.licenseConditions = license.licenseConditions;
        }
        if (license.licenseLimitations != null) {
            this.licenseLimitations = license.licenseLimitations;
        }
        if (license.licenseDescription != null) {
            this.licenseDescription = license.licenseDescription;
        }
        if (!(this.licenseBody != null && this.licenseBody.startsWith("^") || license.licenseBody == null)) {
            this.licenseBody = license.licenseBody;
        }
        for (LinkInfoData link : license.links) {
            if (this.links.contains(link)) {
                this.links.get(this.links.indexOf(link)).merge(link);
                continue;
            }
            this.links.add(link);
        }
    }

    public boolean hasEverythingGeneric() {
        return this.description != null && this.description.startsWith("^") && this.websiteUrl != null && this.websiteUrl.startsWith("^") && this.licenseName != null && this.licenseName.startsWith("^");
    }

    public boolean hasEverythingLicense() {
        return this.licenseName != null && this.licenseName.startsWith("^") && this.licenseUrl != null && this.licenseUrl.startsWith("^") && this.licenseBody != null && this.licenseBody.startsWith("^");
    }

    public boolean equals(Object obj) {
        return obj instanceof LicenseInfoData && (this.repo != null ? this.repo.equals(((LicenseInfoData)obj).repo) || this.repo.equals(((LicenseInfoData)obj).title) : (this.title != null ? this.title.equals(((LicenseInfoData)obj).repo) : super.equals(obj)));
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    @Override
    public void bind(Context context, ViewHolder viewHolder) {
        viewHolder.titleView.setText((CharSequence)ResourceUtils.getString(context, this.getName()));
        viewHolder.descriptionView.setText((CharSequence)ResourceUtils.getString(context, this.description));
        if (this.licenseName != null) {
            viewHolder.licenseView.setVisibility(0);
            viewHolder.licenseView.setText((CharSequence)ResourceUtils.getString(context, this.licenseName));
        } else {
            viewHolder.licenseView.setVisibility(8);
        }
        if (this.links.size() > 0) {
            Collections.sort(this.links);
            viewHolder.links.setVisibility(0);
            FlexboxLayoutManager layoutManager = new FlexboxLayoutManager(context);
            layoutManager.setFlexDirection(0);
            layoutManager.setJustifyContent(0);
            viewHolder.links.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            viewHolder.links.setAdapter((RecyclerView.Adapter)new InfoAdapter(new ArrayList<InfoData>(this.links)));
        } else {
            viewHolder.links.setVisibility(8);
        }
        LinkInfoData importantLink = null;
        for (LinkInfoData link : this.links) {
            if (importantLink != null && link.getPriority() <= importantLink.getPriority()) continue;
            importantLink = link;
        }
        viewHolder.itemView.setOnClickListener(importantLink != null ? importantLink.getListener(context) : null);
    }

    static class ViewHolder
    extends InfoData.ViewHolder {
        private TextView titleView;
        private TextView descriptionView;
        private TextView licenseView;
        private RecyclerView links;

        ViewHolder(View v) {
            super(v);
            this.titleView = (TextView)v.findViewById(R.id.title);
            this.descriptionView = (TextView)v.findViewById(R.id.description);
            this.licenseView = (TextView)v.findViewById(R.id.license);
            this.links = (RecyclerView)v.findViewById(R.id.projectLinks);
        }
    }
}

