/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.data.github;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public abstract class GitHubData {
    private String url;
    private GitHubThread thread;
    private Gson gson;
    private boolean isInitialized;
    private List<OnInitListener> listeners;
    private List<String> tags;

    GitHubData(String url) {
        this.url = url;
        this.listeners = new ArrayList<OnInitListener>();
        this.tags = new ArrayList<String>();
        this.gson = new GsonBuilder().registerTypeAdapter(this.getClass(), (Object)new MootInstanceCreator(this)).create();
    }

    private void init(String json) {
        this.initJson(this.gson, json);
        this.onInit();
        this.isInitialized = true;
        for (OnInitListener listener : this.listeners) {
            listener.onInit(this);
        }
    }

    protected void initJson(Gson gson, String json) {
        gson.fromJson(json, this.getClass());
    }

    protected void onInit() {
    }

    public final void startInit(Context context, String token) {
        this.thread = new GitHubThread(context, token, this, this.url);
        this.thread.start();
    }

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    public final GitHubData merge(GitHubData data) {
        for (OnInitListener listener : data.listeners) {
            if (this.listeners.contains(listener)) continue;
            this.listeners.add(listener);
        }
        for (String tag : data.tags) {
            this.addTag(tag);
        }
        return this;
    }

    public final void addTag(String tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    public final List<String> getTags() {
        return this.tags;
    }

    public final void addOnInitListener(OnInitListener listener) {
        this.listeners.add(listener);
    }

    public final void removeOnInitListener(OnInitListener listener) {
        this.listeners.remove(listener);
    }

    public final void interruptThread() {
        if (this.thread != null && this.thread.isAlive() && !this.thread.isInterrupted()) {
            this.thread.interrupt();
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof GitHubData && ((GitHubData)obj).url.equals(this.url);
    }

    public static interface OnInitListener {
        public void onInit(GitHubData var1);

        public void onFailure(GitHubData var1);
    }

    private static class GitHubThread
    extends Thread {
        private File cacheFile;
        private GitHubData data;
        private String url;
        private String token;
        private Gson gson;

        private GitHubThread(Context context, String token, GitHubData data, String url) {
            this.data = data;
            this.url = url;
            this.token = token;
            this.gson = new GsonBuilder().setLenient().create();
            this.cacheFile = new File(context.getCacheDir(), ".attriboutergithubcache");
        }

        @Override
        public void run() {
            HashMap<String, String> cache = null;
            if (Math.abs(System.currentTimeMillis() - this.cacheFile.lastModified()) < 864000000L) {
                Object cached;
                StringBuilder cacheBuilder = new StringBuilder();
                Scanner cacheScanner = null;
                try {
                    cacheScanner = new Scanner(this.cacheFile);
                    while (cacheScanner.hasNext()) {
                        cacheBuilder.append(cacheScanner.nextLine());
                    }
                    cache = (Map)this.gson.fromJson(cacheBuilder.toString(), new HashMap().getClass());
                }
                catch (IOException iOException) {
                }
                catch (Exception e) {
                    this.cacheFile.delete();
                }
                if (cacheScanner != null) {
                    cacheScanner.close();
                }
                if (cache != null && cache.containsKey(this.url) && (cached = cache.get(this.url)) instanceof String) {
                    this.callInit((String)cached);
                    return;
                }
            }
            HttpURLConnection connection = null;
            BufferedReader jsonReader = null;
            StringBuilder jsonBuilder = new StringBuilder();
            try {
                String line;
                connection = (HttpURLConnection)new URL(this.url).openConnection();
                if (this.token != null) {
                    connection.setRequestProperty("Authorization", "token " + this.token);
                }
                jsonReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                if (connection.getResponseCode() == 403) {
                    jsonReader.close();
                    return;
                }
                while ((line = jsonReader.readLine()) != null) {
                    jsonBuilder.append(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                jsonBuilder = null;
            }
            if (connection != null) {
                connection.disconnect();
            }
            if (jsonReader != null) {
                try {
                    jsonReader.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (jsonBuilder != null) {
                String json = jsonBuilder.toString();
                this.callInit(json);
                if (cache == null) {
                    cache = new HashMap<String, String>();
                }
                cache.put(this.url, json);
                PrintWriter cacheWriter = null;
                try {
                    cacheWriter = new PrintWriter(this.cacheFile);
                    cacheWriter.println(this.gson.toJson(cache));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (cacheWriter != null) {
                    cacheWriter.close();
                }
            }
        }

        private void callInit(final String json) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    GitHubThread.this.data.init(json);
                }
            });
        }
    }

    private static class MootInstanceCreator
    implements InstanceCreator<GitHubData> {
        private GitHubData instance;

        public MootInstanceCreator(GitHubData instance) {
            this.instance = instance;
        }

        public GitHubData createInstance(Type type) {
            return this.instance;
        }
    }
}

