/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.fragments;

import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.adapters.InfoAdapter;
import me.jfenn.attribouter.data.github.GitHubData;
import me.jfenn.attribouter.data.info.AppInfoData;
import me.jfenn.attribouter.data.info.ContributorsInfoData;
import me.jfenn.attribouter.data.info.InfoData;
import me.jfenn.attribouter.data.info.LicensesInfoData;
import me.jfenn.attribouter.data.info.TextInfoData;
import org.xmlpull.v1.XmlPullParserException;

public class AboutFragment
extends Fragment
implements GitHubData.OnInitListener,
InfoData.OnRequestListener {
    private RecyclerView recycler;
    private InfoAdapter adapter;
    private List<InfoData> infos;
    private List<GitHubData> requests;
    private String gitHubToken;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.recycler = (RecyclerView)inflater.inflate(R.layout.fragment_attribouter_about, container, false);
        this.infos = new ArrayList<InfoData>();
        Bundle args = this.getArguments();
        int fileRes = R.xml.attribouter;
        if (args != null) {
            this.gitHubToken = args.getString("me.jfenn.attribouter.EXTRA_GITHUB_OAUTH_TOKEN", null);
            fileRes = args.getInt("me.jfenn.attribouter.EXTRA_FILE_RES", R.xml.attribouter);
        }
        XmlResourceParser parser = this.getResources().getXml(fileRes);
        try {
            while (parser.getEventType() != 1) {
                if (parser.getEventType() == 2) {
                    switch (parser.getName()) {
                        case "appInfo": {
                            this.infos.add(new AppInfoData(parser));
                            break;
                        }
                        case "contributors": {
                            this.infos.add(new ContributorsInfoData(parser));
                            break;
                        }
                        case "licenses": {
                            this.infos.add(new LicensesInfoData(parser));
                            break;
                        }
                        case "text": {
                            this.infos.add(new TextInfoData(parser));
                        }
                    }
                }
                parser.next();
            }
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
        }
        parser.close();
        this.adapter = new InfoAdapter(this.infos);
        this.recycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.recycler.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(this.recycler.getContext(), 1));
        this.recycler.setAdapter((RecyclerView.Adapter)this.adapter);
        this.requests = new ArrayList<GitHubData>();
        for (InfoData info : this.infos) {
            for (GitHubData request : info.getRequests()) {
                if (!this.requests.contains(request)) {
                    this.requests.add(request);
                    continue;
                }
                int i = this.requests.indexOf(request);
                this.requests.set(i, request.merge(this.requests.get(i)));
            }
            info.setOnRequestListener(this);
        }
        for (GitHubData request : this.requests) {
            request.addOnInitListener(this);
            request.startInit(this.getContext(), this.gitHubToken);
        }
        return this.recycler;
    }

    @Override
    public void onInit(GitHubData data) {
        for (int i = 0; i < this.infos.size(); ++i) {
            if (!this.infos.get(i).hasRequest(data)) continue;
            this.adapter.notifyItemChanged(i);
        }
        this.recycler.smoothScrollToPosition(0);
    }

    @Override
    public void onFailure(GitHubData data) {
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.requests != null) {
            for (GitHubData request : this.requests) {
                request.interruptThread();
            }
        }
    }

    @Override
    public void onRequest(InfoData info, GitHubData request) {
        if (!this.requests.contains(request)) {
            this.requests.add(request);
            request.addOnInitListener(this);
            request.startInit(this.getContext(), this.gitHubToken);
        } else {
            int i = this.requests.indexOf(request);
            GitHubData activeRequest = this.requests.get(i).merge(request);
            if (activeRequest.isInitialized()) {
                info.onInit(activeRequest);
            }
        }
    }
}

