/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.dialogs;

import android.content.Context;
import android.os.Bundle;
import android.support.v7.app.AppCompatDialog;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.data.info.ContributorInfoData;
import me.jfenn.attribouter.utils.ResourceUtils;
import me.jfenn.attribouter.utils.UrlClickListener;

public class UserDialog
extends AppCompatDialog {
    private ContributorInfoData contributor;

    public UserDialog(Context context, ContributorInfoData contributor) {
        super(context);
        this.contributor = contributor;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dialog_attribouter_user);
        TextView nameView = (TextView)this.findViewById(R.id.name);
        TextView taskView = (TextView)this.findViewById(R.id.task);
        ImageView imageView = (ImageView)this.findViewById(R.id.image);
        TextView bioView = (TextView)this.findViewById(R.id.description);
        View links = this.findViewById(R.id.links);
        View websiteButton = this.findViewById(R.id.website);
        View gitHubButton = this.findViewById(R.id.gitHub);
        View emailButton = this.findViewById(R.id.email);
        nameView.setText((CharSequence)ResourceUtils.getString(this.getContext(), this.contributor.getName()));
        taskView.setText((CharSequence)ResourceUtils.getString(this.getContext(), this.contributor.task));
        String url = ResourceUtils.getString(this.getContext(), this.contributor.avatarUrl);
        if (url != null) {
            ResourceUtils.setImage(this.getContext(), this.contributor.avatarUrl, imageView);
        } else {
            imageView.setVisibility(8);
        }
        bioView.setText((CharSequence)ResourceUtils.getString(this.getContext(), this.contributor.bio));
        links.setVisibility(this.contributor.login != null || this.contributor.blog != null || this.contributor.email != null ? 0 : 8);
        String blog = ResourceUtils.getString(this.getContext(), this.contributor.blog);
        if (blog != null) {
            websiteButton.setVisibility(0);
            websiteButton.setOnClickListener((View.OnClickListener)new UrlClickListener(blog));
        } else {
            websiteButton.setVisibility(8);
        }
        if (this.contributor.login != null) {
            gitHubButton.setVisibility(0);
            gitHubButton.setOnClickListener((View.OnClickListener)new UrlClickListener("https://github.com/" + this.contributor.login));
        } else {
            gitHubButton.setVisibility(8);
        }
        if (this.contributor.email != null) {
            emailButton.setVisibility(0);
            emailButton.setOnClickListener((View.OnClickListener)new UrlClickListener("mailto:" + this.contributor.email));
        } else {
            emailButton.setVisibility(8);
        }
    }
}

