/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.attribouter.data.info;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.jfenn.attribouter.R;
import me.jfenn.attribouter.adapters.InfoAdapter;
import me.jfenn.attribouter.data.github.ContributorsData;
import me.jfenn.attribouter.data.github.GitHubData;
import me.jfenn.attribouter.data.github.UserData;
import me.jfenn.attribouter.data.info.ContributorInfoData;
import me.jfenn.attribouter.data.info.InfoData;
import me.jfenn.attribouter.dialogs.UserDialog;
import me.jfenn.attribouter.utils.ResourceUtils;
import org.xmlpull.v1.XmlPullParserException;

public class ContributorsInfoData
extends InfoData<ViewHolder> {
    private String repo;
    private String contributorsTitle;
    private List<ContributorInfoData> contributors;

    public ContributorsInfoData(XmlResourceParser parser) throws XmlPullParserException, IOException {
        super(R.layout.item_attribouter_contributors);
        this.repo = parser.getAttributeValue(null, "repo");
        this.contributors = new ArrayList<ContributorInfoData>();
        this.contributorsTitle = parser.getAttributeValue(null, "title");
        while (parser.getEventType() != 3 || parser.getName().equals("contributor")) {
            parser.next();
            if (parser.getEventType() != 2 || !parser.getName().equals("contributor")) continue;
            int position = parser.getAttributeIntValue(null, "position", -1);
            ContributorInfoData contributor = new ContributorInfoData(parser.getAttributeValue(null, "login"), parser.getAttributeValue(null, "name"), parser.getAttributeValue(null, "avatar"), parser.getAttributeValue(null, "task"), position != -1 ? Integer.valueOf(position) : null, parser.getAttributeValue(null, "bio"), parser.getAttributeValue(null, "blog"), parser.getAttributeValue(null, "email"));
            contributor.isHidden = parser.getAttributeBooleanValue(null, "hidden", false);
            if (!this.contributors.contains(contributor)) {
                this.contributors.add(contributor);
                continue;
            }
            this.contributors.get(this.contributors.indexOf(contributor)).merge(contributor);
        }
        ContributorInfoData me = new ContributorInfoData("TheAndroidMaster", "James Fenn", "https://avatars1.githubusercontent.com/u/13000407", "Library Developer", null, "Android developer and co-founder of Double Dot Labs. Writes Java, C, and HTML. PHP confuses me.", "https://jfenn.me/", "dev@jfenn.me");
        if (!this.contributors.contains(me)) {
            this.contributors.add(me);
        }
        this.addRequest(new ContributorsData("TheAndroidMaster/Attribouter"));
        this.addRequest(new ContributorsData(this.repo));
    }

    @Override
    public void onInit(GitHubData data) {
        if (data instanceof ContributorsData) {
            if (((ContributorsData)data).contributors != null) {
                for (ContributorsData.ContributorData contributor : ((ContributorsData)data).contributors) {
                    ContributorInfoData mergeContributor;
                    if (contributor.login == null) continue;
                    ContributorInfoData contributorInfo = mergeContributor = new ContributorInfoData(contributor.login, null, contributor.avatar_url, this.repo.startsWith(contributor.login) ? "Owner" : "Contributor", null, null, null, null);
                    if (this.contributors.contains(mergeContributor)) {
                        contributorInfo = this.contributors.get(this.contributors.indexOf(mergeContributor));
                        contributorInfo.merge(mergeContributor);
                    } else {
                        this.contributors.add(contributorInfo);
                    }
                    if (contributorInfo.hasEverything()) continue;
                    this.addRequest(new UserData(contributor.login));
                }
            }
        } else if (data instanceof UserData) {
            UserData user = (UserData)data;
            ContributorInfoData contributor = new ContributorInfoData(user.login, user.name, user.avatar_url, this.repo.startsWith(user.login) ? "Owner" : "Contributor", null, user.bio, user.blog, user.email);
            if (!this.contributors.contains(contributor)) {
                this.contributors.add(0, contributor);
            } else {
                this.contributors.get(this.contributors.indexOf(contributor)).merge(contributor);
            }
        }
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    @Override
    public void bind(Context context, ViewHolder viewHolder) {
        if (this.contributorsTitle != null) {
            viewHolder.titleView.setText((CharSequence)ResourceUtils.getString(context, this.contributorsTitle));
        }
        ContributorInfoData first = null;
        ContributorInfoData second = null;
        ContributorInfoData third = null;
        ArrayList<InfoData> remainingContributors = new ArrayList<InfoData>();
        for (ContributorInfoData contributor : this.contributors) {
            if (contributor.isHidden) continue;
            if (contributor.position != null) {
                if (first == null && contributor.position == 1) {
                    first = contributor;
                    continue;
                }
                if (second == null && contributor.position == 2) {
                    second = contributor;
                    continue;
                }
                if (third == null && contributor.position == 3) {
                    third = contributor;
                    continue;
                }
            }
            remainingContributors.add(contributor);
        }
        if (first != null && second != null && third != null) {
            viewHolder.topThreeView.setVisibility(0);
            viewHolder.firstNameView.setText((CharSequence)ResourceUtils.getString(context, first.getName()));
            ResourceUtils.setImage(context, first.avatarUrl, viewHolder.firstImageView);
            if (first.task != null) {
                viewHolder.firstTaskView.setVisibility(0);
                viewHolder.firstTaskView.setText((CharSequence)ResourceUtils.getString(context, first.task));
            } else {
                viewHolder.firstTaskView.setVisibility(8);
            }
            viewHolder.firstView.setTag((Object)first);
            viewHolder.firstView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    new UserDialog(view.getContext(), (ContributorInfoData)view.getTag()).show();
                }
            });
            viewHolder.secondNameView.setText((CharSequence)ResourceUtils.getString(context, second.getName()));
            ResourceUtils.setImage(context, second.avatarUrl, viewHolder.secondImageView);
            if (second.task != null) {
                viewHolder.secondTaskView.setVisibility(0);
                viewHolder.secondTaskView.setText((CharSequence)ResourceUtils.getString(context, second.task));
            } else {
                viewHolder.secondTaskView.setVisibility(8);
            }
            viewHolder.secondView.setTag((Object)second);
            viewHolder.secondView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    new UserDialog(view.getContext(), (ContributorInfoData)view.getTag()).show();
                }
            });
            viewHolder.thirdNameView.setText((CharSequence)ResourceUtils.getString(context, third.getName()));
            ResourceUtils.setImage(context, third.avatarUrl, viewHolder.thirdImageView);
            if (third.task != null) {
                viewHolder.thirdTaskView.setVisibility(0);
                viewHolder.thirdTaskView.setText((CharSequence)ResourceUtils.getString(context, third.task));
            } else {
                viewHolder.thirdTaskView.setVisibility(8);
            }
            viewHolder.thirdView.setTag((Object)third);
            viewHolder.thirdView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    new UserDialog(view.getContext(), (ContributorInfoData)view.getTag()).show();
                }
            });
        } else {
            viewHolder.topThreeView.setVisibility(8);
            if (third != null) {
                remainingContributors.add(0, third);
            }
            if (second != null) {
                remainingContributors.add(0, second);
            }
            if (first != null) {
                remainingContributors.add(0, first);
            }
        }
        if (remainingContributors.size() > 0) {
            viewHolder.recycler.setVisibility(0);
            viewHolder.recycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
            viewHolder.recycler.setAdapter((RecyclerView.Adapter)new InfoAdapter(remainingContributors));
        } else {
            viewHolder.recycler.setVisibility(8);
        }
    }

    class ViewHolder
    extends InfoData.ViewHolder {
        private TextView titleView;
        private View topThreeView;
        private View firstView;
        private ImageView firstImageView;
        private TextView firstNameView;
        private TextView firstTaskView;
        private View secondView;
        private ImageView secondImageView;
        private TextView secondNameView;
        private TextView secondTaskView;
        private View thirdView;
        private ImageView thirdImageView;
        private TextView thirdNameView;
        private TextView thirdTaskView;
        private RecyclerView recycler;

        ViewHolder(View v) {
            super(v);
            this.titleView = (TextView)v.findViewById(R.id.contributorsTitle);
            this.topThreeView = v.findViewById(R.id.topThree);
            this.firstView = v.findViewById(R.id.first);
            this.firstImageView = (ImageView)v.findViewById(R.id.firstImage);
            this.firstNameView = (TextView)v.findViewById(R.id.firstName);
            this.firstTaskView = (TextView)v.findViewById(R.id.firstTask);
            this.secondView = v.findViewById(R.id.second);
            this.secondImageView = (ImageView)v.findViewById(R.id.secondImage);
            this.secondNameView = (TextView)v.findViewById(R.id.secondName);
            this.secondTaskView = (TextView)v.findViewById(R.id.secondTask);
            this.thirdView = v.findViewById(R.id.third);
            this.thirdImageView = (ImageView)v.findViewById(R.id.thirdImage);
            this.thirdNameView = (TextView)v.findViewById(R.id.thirdName);
            this.thirdTaskView = (TextView)v.findViewById(R.id.thirdTask);
            this.recycler = (RecyclerView)v.findViewById(R.id.recycler);
        }
    }
}

